/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.type;

import com.objectdb.conv.ConvertManager;
import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.type.OldTypeInfo;
import com.objectdb.conv1.type.OldTypeManager;
import com.objectdb.conv1.type.OldUpgradeProgram;
import com.objectdb.conv1.type.OldUserFieldInfo;
import com.objectdb.o.ALS;
import com.objectdb.o.IXD;
import com.objectdb.o.MDF;
import com.objectdb.o.STH;
import com.objectdb.o.TDF;
import com.objectdb.o.TYW;

public final class OldUserTypeInfo
extends OldTypeInfo {
    OldUserTypeInfo m_superTypeInfo;
    public int m_oldTypeId;
    boolean m_isUpToDate;
    boolean m_isAbstract;
    boolean m_hasExtent;
    String[] m_indexPaths;
    OldUserFieldInfo[] m_fields;
    int[] m_persistentFieldIndexes;
    byte[] m_jumpCodes;
    int[] m_fieldWritingPos;
    OldUpgradeProgram m_upgradeProgram;

    OldUserTypeInfo(OldBuffer oldBuffer, OldTypeManager oldTypeManager, boolean bl) {
        super(oldTypeManager, (String)null, 0);
        this.readVersion(oldBuffer);
        this.m_isUpToDate = bl;
    }

    public OldUserFieldInfo[] getFields() {
        return this.m_fields;
    }

    public int getVerFieldCount() {
        return this.m_fields.length - this.getSuperFieldCount();
    }

    public OldUserFieldInfo getVerField(int n) {
        return this.m_fields[n + this.getSuperFieldCount()];
    }

    public int getSuperFieldCount() {
        if (this.m_superTypeInfo == null) {
            return 0;
        }
        return this.m_superTypeInfo.m_fields.length;
    }

    public OldUserTypeInfo getSuperTypeInfo() {
        return this.m_superTypeInfo;
    }

    public boolean isUpToDate() {
        return this.m_isUpToDate;
    }

    public boolean isAbstract() {
        return this.m_isAbstract;
    }

    public boolean hasExtent() {
        return this.m_hasExtent;
    }

    public Class getTypeClass() {
        if (this.m_class == null) {
            this.m_class = this.m_typeManager.loadPersistentClass(this.getClassName());
        }
        return this.m_class;
    }

    void readVersion(OldBuffer oldBuffer) {
        oldBuffer.skip(4);
        if (oldBuffer.readCompressedULong2() != 0L) {
            throw new RuntimeException("Bad version buffer format");
        }
        int n = oldBuffer.readInt();
        this.setTypeId(n);
        int n2 = oldBuffer.readInt();
        if (n2 != 0) {
            int n3 = oldBuffer.getPos();
            this.m_superTypeInfo = (OldUserTypeInfo)this.m_typeManager.getTypeInfo(n2 << 4);
            oldBuffer.setPos(n3);
        }
        this.m_oldTypeId = oldBuffer.readCompressedUInt();
        String string = oldBuffer.readString();
        this.setClassName(string);
        oldBuffer.skipString();
        oldBuffer.skipString();
        this.m_isAbstract = oldBuffer.readBoolean();
        this.m_hasExtent = oldBuffer.readBoolean();
        int n4 = oldBuffer.readCompressedUInt();
        int n5 = this.getSuperFieldCount();
        int n6 = n4 + n5;
        this.m_fields = new OldUserFieldInfo[n6];
        if (n5 > 0) {
            System.arraycopy(this.m_superTypeInfo.m_fields, 0, this.m_fields, 0, n5);
        }
        for (int i = n5; i < n6; ++i) {
            this.m_fields[i] = new OldUserFieldInfo(i, oldBuffer, this);
        }
        this.m_persistentFieldIndexes = oldBuffer.readUIntArray();
        oldBuffer.readCompressedUInt();
        this.m_fieldWritingPos = oldBuffer.readUIntArray();
        this.m_jumpCodes = oldBuffer.readByteArray();
        oldBuffer.readCompressedULong2();
        oldBuffer.readBoolean();
        this.m_indexPaths = oldBuffer.readStringArray();
        oldBuffer.skip(8);
    }

    public void skipElement(OldBuffer oldBuffer) {
        OldTypeManager oldTypeManager = this.m_typeManager;
        byte[] byArray = this.m_jumpCodes;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by != -4) {
                oldBuffer.jumpOnFieldValue(by);
                continue;
            }
            oldTypeManager.skipElement(oldBuffer);
        }
    }

    public boolean isAssignableFrom(OldTypeInfo oldTypeInfo) {
        if (oldTypeInfo == null) {
            return false;
        }
        if (oldTypeInfo == this || oldTypeInfo.getClassName().equals(this.getClassName())) {
            return true;
        }
        if (this.m_class != null && oldTypeInfo.m_class != null) {
            return super.isAssignableFrom(oldTypeInfo);
        }
        if (!(oldTypeInfo instanceof OldUserTypeInfo)) {
            return false;
        }
        return this.isAssignableFrom(((OldUserTypeInfo)oldTypeInfo).getSuperTypeInfo());
    }

    public OldUserTypeInfo getUpToDateTypeInfo() {
        if (this.m_isUpToDate) {
            return this;
        }
        if (this.m_upgradeProgram == null) {
            this.m_upgradeProgram = new OldUpgradeProgram(this);
        }
        return this.m_upgradeProgram.m_targetTypeInfo;
    }

    public int[] getPersistentFieldIndexes() {
        return this.m_persistentFieldIndexes;
    }

    public int[] getFieldWritingPos() {
        return this.m_fieldWritingPos;
    }

    public byte[] getJumpCodes() {
        return this.m_jumpCodes;
    }

    public TDF convertType(boolean bl, ConvertManager convertManager) {
        TDF tDF = new TDF(this.getClassName());
        int n = 0x800000;
        n |= (bl |= this.isAbstract()) ? 1 : 4;
        if (!this.hasExtent()) {
            n |= 0x80000;
        }
        if (this.isAbstract()) {
            n |= 0x100;
        }
        tDF.Q(n);
        if (this.m_superTypeInfo != null) {
            String string = this.m_superTypeInfo.getClassName();
            tDF.aa(string);
            tDF.Y(string);
        }
        int n2 = this.getVerFieldCount();
        MDF[] mDFArray = new MDF[n2];
        int n3 = this.m_superTypeInfo != null ? this.m_superTypeInfo.getPersistentFieldIndexes().length : 0;
        for (int i = 0; i < n2; ++i) {
            MDF mDF;
            String[] stringArray = this.getVerField(i);
            mDFArray[i] = mDF = stringArray.convert(convertManager);
            if (!mDF.v()) continue;
            stringArray.setNewFieldIndex(n3++);
        }
        tDF.W(mDFArray);
        ALS<IXD> aLS = new ALS<IXD>(4);
        for (String string : this.m_indexPaths) {
            boolean bl2 = false;
            if (string.endsWith("*")) {
                bl2 = true;
                string = STH.m(string, string.length() - 1);
            }
            if ("institutionNumber".equals(string) && "ca.archives.rdacs.model.Institution".equals(this.getClassName())) continue;
            aLS.a(new IXD(null, new String[]{string}, bl2));
        }
        if (!aLS.m()) {
            tDF.T(aLS);
        }
        return tDF;
    }

    public void convertObject(OldBuffer oldBuffer, boolean bl, ConvertManager convertManager, TYW tYW) {
        int n;
        if (!this.m_isUpToDate) {
            if (this.m_upgradeProgram == null) {
                this.m_upgradeProgram = new OldUpgradeProgram(this);
            }
            OldBuffer oldBuffer2 = this.m_upgradeProgram.upgrade(oldBuffer, bl);
            oldBuffer2.setPos(0);
            if (this.m_upgradeProgram.m_targetTypeInfo == this) {
                throw new RuntimeException("Internal Exception");
            }
            OldUserTypeInfo oldUserTypeInfo = this.m_upgradeProgram.m_targetTypeInfo;
            ((OldTypeInfo)oldUserTypeInfo).convertObject(oldBuffer2, bl, convertManager, tYW);
            return;
        }
        int[] nArray = this.m_persistentFieldIndexes;
        OldUserFieldInfo[] oldUserFieldInfoArray = this.m_fields;
        int n2 = oldUserFieldInfoArray.length;
        byte[][] byArrayArray = new byte[n2][];
        int n3 = tYW.c();
        for (n = 0; n < n2; ++n) {
            OldUserFieldInfo oldUserFieldInfo = oldUserFieldInfoArray[nArray[n]];
            this.convertFieldValue(oldBuffer, oldUserFieldInfo, bl, convertManager, tYW);
            int n4 = tYW.c();
            int n5 = n4 - n3;
            byte[] byArray = new byte[n5];
            System.arraycopy(tYW.a(), n3, byArray, 0, n5);
            byArrayArray[oldUserFieldInfo.getFieldIndex()] = byArray;
            tYW.g(n3);
        }
        if (!bl) {
            tYW.u(0);
            tYW.P(convertManager.getNewType(this.getClassName()).getId());
            tYW.u(0);
        }
        for (n = 0; n < n2; ++n) {
            tYW.h(byArrayArray[n]);
        }
        if (!bl) {
            tYW.S(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void convertFieldValue(OldBuffer oldBuffer, OldUserFieldInfo oldUserFieldInfo, boolean bl, ConvertManager convertManager, TYW tYW) {
        convertManager.pushPath(oldUserFieldInfo.getName());
        try {
            if (!oldUserFieldInfo.isPrimitiveOrString()) {
                convertManager.convertElement(oldBuffer, bl, tYW);
                return;
            }
            switch (oldUserFieldInfo.getPrimitiveCode()) {
                case 12: {
                    tYW.writeBooleanValue(oldBuffer.readBoolean());
                    return;
                }
                case 1: {
                    tYW.writeSByteValue(oldBuffer.readByte());
                    return;
                }
                case 3: {
                    tYW.writeSInt16Value((short)oldBuffer.readShort());
                    return;
                }
                case 2: {
                    tYW.writeCharValue(oldBuffer.readChar());
                    return;
                }
                case 4: {
                    tYW.writeSInt32Value(oldBuffer.readCompressedInt());
                    return;
                }
                case 5: {
                    tYW.writeSInt64Value(oldBuffer.readCompressedLong());
                    return;
                }
                case 6: {
                    tYW.writeFloatValue(oldBuffer.readFloat());
                    return;
                }
                case 7: {
                    tYW.writeDoubleValue(oldBuffer.readDouble());
                    return;
                }
                default: {
                    tYW.writeStringValue(oldBuffer.readString());
                    return;
                }
            }
        }
        finally {
            convertManager.popPath();
        }
    }
}

