/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.jpa.criteria;

import com.objectdb.jpa.criteria.Expressions;
import com.objectdb.jpa.criteria.FromImpl;
import com.objectdb.jpa.criteria.JpqlWriter;
import com.objectdb.jpa.criteria.PathImpl;
import java.util.Map;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.SetJoin;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SetAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JoinImpl<Z, T>
extends FromImpl<Z, T>
implements Join<Z, T>,
Fetch<Z, T> {
    final JoinType m_joinType;
    final FromImpl<?, Z> m_parent;
    final boolean m_isFetch;

    JoinImpl(Metamodel metamodel, FromImpl fromImpl, Path<?> path, JoinType joinType, boolean bl) {
        super(metamodel, path, path.getModel());
        this.m_parent = fromImpl;
        this.m_joinType = joinType;
        this.m_isFetch = bl;
    }

    public JoinImpl(JoinImpl<Z, T> joinImpl) {
        super(joinImpl);
        this.m_parent = null;
        this.m_joinType = joinImpl.m_joinType;
        this.m_isFetch = false;
    }

    @Override
    public final From<?, Z> getParent() {
        return this.m_parent;
    }

    @Override
    public final Attribute<? super Z, ?> getAttribute() {
        return (Attribute)((Object)this.getModel());
    }

    @Override
    public final JoinType getJoinType() {
        return this.m_joinType;
    }

    @Override
    final void writeJpqlFrom(JpqlWriter jpqlWriter) {
        this.m_parent.writeJpql(jpqlWriter);
        jpqlWriter.write(".").write(((Attribute)((Object)this.getModel())).getName());
        if (!this.m_isFetch) {
            jpqlWriter.write(" ");
            this.writeJpql(jpqlWriter);
        }
        super.writeJpqlFrom(jpqlWriter);
    }

    final void writeJpqlJoin(JpqlWriter jpqlWriter) {
        if (this.m_joinType != JoinType.INNER) {
            jpqlWriter.write(" ").write(this.m_joinType.toString());
        }
        jpqlWriter.write(" JOIN ");
        if (this.m_isFetch) {
            jpqlWriter.write("FETCH ");
        }
        this.writeJpqlFrom(jpqlWriter);
    }

    @Override
    public Join<Z, T> on(Expression<Boolean> expression) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Join<Z, T> on(Predicate ... predicateArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Predicate getOn() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MapJoinImpl<Z, K, V>
    extends JoinImpl<Z, V>
    implements MapJoin<Z, K, V> {
        MapJoinImpl(Metamodel metamodel, FromImpl fromImpl, Path<?> path, JoinType joinType) {
            super(metamodel, fromImpl, path, joinType, false);
        }

        public MapJoinImpl(MapJoinImpl<Z, K, V> mapJoinImpl) {
            super(mapJoinImpl);
        }

        @Override
        public MapAttribute<? super Z, K, V> getModel() {
            return (MapAttribute)super.getModel();
        }

        @Override
        public Expression<Map.Entry<K, V>> entry() {
            return Expressions.function(Object.class, "ENTRY", this);
        }

        @Override
        public Path<K> key() {
            return new PathImpl(this.m_metamodel, this, null);
        }

        @Override
        public Path<V> value() {
            return this;
        }

        @Override
        public MapJoin<Z, K, V> on(Expression<Boolean> expression) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MapJoin<Z, K, V> on(Predicate ... predicateArray) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ListJoinImpl<Z, E>
    extends JoinImpl<Z, E>
    implements ListJoin<Z, E> {
        ListJoinImpl(Metamodel metamodel, FromImpl fromImpl, Path<?> path, JoinType joinType) {
            super(metamodel, fromImpl, path, joinType, false);
        }

        public ListJoinImpl(ListJoinImpl<Z, E> listJoinImpl) {
            super(listJoinImpl);
        }

        @Override
        public ListAttribute<? super Z, E> getModel() {
            return (ListAttribute)super.getModel();
        }

        @Override
        public Expression<Integer> index() {
            return Expressions.function(Integer.class, "INDEX", this);
        }

        @Override
        public ListJoin<Z, E> on(Expression<Boolean> expression) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListJoin<Z, E> on(Predicate ... predicateArray) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SetJoinImpl<Z, E>
    extends JoinImpl<Z, E>
    implements SetJoin<Z, E> {
        SetJoinImpl(Metamodel metamodel, FromImpl fromImpl, Path<?> path, JoinType joinType) {
            super(metamodel, fromImpl, path, joinType, false);
        }

        public SetJoinImpl(SetJoinImpl<Z, E> setJoinImpl) {
            super(setJoinImpl);
        }

        @Override
        public SetAttribute<? super Z, E> getModel() {
            return (SetAttribute)super.getModel();
        }

        @Override
        public SetJoin<Z, E> on(Expression<Boolean> expression) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SetJoin<Z, E> on(Predicate ... predicateArray) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CollectionJoinImpl<Z, E>
    extends JoinImpl<Z, E>
    implements CollectionJoin<Z, E> {
        CollectionJoinImpl(Metamodel metamodel, FromImpl fromImpl, Path<?> path, JoinType joinType) {
            super(metamodel, fromImpl, path, joinType, false);
        }

        public CollectionJoinImpl(CollectionJoinImpl<Z, E> collectionJoinImpl) {
            super(collectionJoinImpl);
        }

        @Override
        public CollectionAttribute<? super Z, E> getModel() {
            return (CollectionAttribute)super.getModel();
        }

        @Override
        public CollectionJoin<Z, E> on(Expression<Boolean> expression) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CollectionJoin<Z, E> on(Predicate ... predicateArray) {
            throw new UnsupportedOperationException();
        }
    }
}

