/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jdo.Constants;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.ObjectState;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.spi.I18NHelper;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateInterrogation;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JDOHelper
implements Constants {
    static final Map ATTRIBUTE_PROPERTY_XREF = JDOHelper.createAttributePropertyXref();
    static final I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    static JDOImplHelper implHelper = (JDOImplHelper)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return JDOImplHelper.getInstance();
        }
    });
    static JDOHelper instance = new JDOHelper();
    static JDOImplHelper.StateInterrogationObjectReturn getPersistenceManager = new JDOImplHelper.StateInterrogationObjectReturn(){

        public Object get(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.getPersistenceManager(object);
        }
    };
    static JDOImplHelper.StateInterrogationObjectReturn getObjectId = new JDOImplHelper.StateInterrogationObjectReturn(){

        public Object get(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.getObjectId(object);
        }
    };
    static JDOImplHelper.StateInterrogationObjectReturn getTransactionalObjectId = new JDOImplHelper.StateInterrogationObjectReturn(){

        public Object get(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.getTransactionalObjectId(object);
        }
    };
    static JDOImplHelper.StateInterrogationObjectReturn getVersion = new JDOImplHelper.StateInterrogationObjectReturn(){

        public Object get(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.getVersion(object);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isPersistent = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.isPersistent(object);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isTransactional = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.isTransactional(object);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isDirty = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.isDirty(object);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isNew = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.isNew(object);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isDeleted = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.isDeleted(object);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isDetached = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.isDetached(object);
        }
    };

    static Map createAttributePropertyXref() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("class", "javax.jdo.PersistenceManagerFactoryClass");
        hashMap.put("connection-driver-name", "javax.jdo.option.ConnectionDriverName");
        hashMap.put("connection-factory-name", "javax.jdo.option.ConnectionFactoryName");
        hashMap.put("connection-factory2-name", "javax.jdo.option.ConnectionFactory2Name");
        hashMap.put("connection-password", "javax.jdo.option.ConnectionPassword");
        hashMap.put("connection-url", "javax.jdo.option.ConnectionURL");
        hashMap.put("connection-user-name", "javax.jdo.option.ConnectionUserName");
        hashMap.put("ignore-cache", "javax.jdo.option.IgnoreCache");
        hashMap.put("mapping", "javax.jdo.option.Mapping");
        hashMap.put("multithreaded", "javax.jdo.option.Multithreaded");
        hashMap.put("nontransactional-read", "javax.jdo.option.NontransactionalRead");
        hashMap.put("nontransactional-write", "javax.jdo.option.NontransactionalWrite");
        hashMap.put("optimistic", "javax.jdo.option.Optimistic");
        hashMap.put("persistence-unit-name", "javax.jdo.option.PersistenceUnitName");
        hashMap.put("name", "javax.jdo.option.Name");
        hashMap.put("restore-values", "javax.jdo.option.RestoreValues");
        hashMap.put("retain-values", "javax.jdo.option.RetainValues");
        hashMap.put("detach-all-on-commit", "javax.jdo.option.DetachAllOnCommit");
        hashMap.put("server-time-zone-id", "javax.jdo.option.ServerTimeZoneID");
        return Collections.unmodifiableMap(hashMap);
    }

    public static JDOHelper getInstance() {
        return instance;
    }

    public static PersistenceManager getPersistenceManager(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoGetPersistenceManager();
        }
        return (PersistenceManager)implHelper.nonBinaryCompatibleGet(object, getPersistenceManager);
    }

    public static void makeDirty(Object object, String string) {
        if (object instanceof PersistenceCapable) {
            ((PersistenceCapable)object).jdoMakeDirty(string);
        } else {
            implHelper.nonBinaryCompatibleMakeDirty(object, string);
        }
    }

    public static Object getObjectId(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoGetObjectId();
        }
        return implHelper.nonBinaryCompatibleGet(object, getObjectId);
    }

    public static Collection getObjectIds(Collection collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(JDOHelper.getObjectId(iterator.next()));
        }
        return arrayList;
    }

    public static Object[] getObjectIds(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray2[i2] = JDOHelper.getObjectId(objectArray[i2]);
        }
        return objectArray2;
    }

    public static Object getTransactionalObjectId(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoGetTransactionalObjectId();
        }
        return implHelper.nonBinaryCompatibleGet(object, getTransactionalObjectId);
    }

    public static Object getVersion(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoGetVersion();
        }
        return implHelper.nonBinaryCompatibleGet(object, getVersion);
    }

    public static boolean isDirty(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsDirty();
        }
        return implHelper.nonBinaryCompatibleIs(object, isDirty);
    }

    public static boolean isTransactional(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsTransactional();
        }
        return implHelper.nonBinaryCompatibleIs(object, isTransactional);
    }

    public static boolean isPersistent(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsPersistent();
        }
        return implHelper.nonBinaryCompatibleIs(object, isPersistent);
    }

    public static boolean isNew(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsNew();
        }
        return implHelper.nonBinaryCompatibleIs(object, isNew);
    }

    public static boolean isDeleted(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsDeleted();
        }
        return implHelper.nonBinaryCompatibleIs(object, isDeleted);
    }

    public static boolean isDetached(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsDetached();
        }
        return implHelper.nonBinaryCompatibleIs(object, isDetached);
    }

    public static ObjectState getObjectState(Object object) {
        if (object == null) {
            return null;
        }
        if (JDOHelper.isDetached(object)) {
            if (JDOHelper.isDirty(object)) {
                return ObjectState.DETACHED_DIRTY;
            }
            return ObjectState.DETACHED_CLEAN;
        }
        if (JDOHelper.isPersistent(object)) {
            if (JDOHelper.isTransactional(object)) {
                if (JDOHelper.isDirty(object)) {
                    if (JDOHelper.isNew(object)) {
                        if (JDOHelper.isDeleted(object)) {
                            return ObjectState.PERSISTENT_NEW_DELETED;
                        }
                        return ObjectState.PERSISTENT_NEW;
                    }
                    if (JDOHelper.isDeleted(object)) {
                        return ObjectState.PERSISTENT_DELETED;
                    }
                    return ObjectState.PERSISTENT_DIRTY;
                }
                return ObjectState.PERSISTENT_CLEAN;
            }
            if (JDOHelper.isDirty(object)) {
                return ObjectState.PERSISTENT_NONTRANSACTIONAL_DIRTY;
            }
            return ObjectState.HOLLOW_PERSISTENT_NONTRANSACTIONAL;
        }
        if (JDOHelper.isTransactional(object)) {
            if (JDOHelper.isDirty(object)) {
                return ObjectState.TRANSIENT_DIRTY;
            }
            return ObjectState.TRANSIENT_CLEAN;
        }
        return ObjectState.TRANSIENT;
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory() {
        ClassLoader classLoader = JDOHelper.getContextClassLoader();
        return JDOHelper.getPersistenceManagerFactory(null, "", classLoader, classLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(ClassLoader classLoader) {
        return JDOHelper.getPersistenceManagerFactory(null, "", classLoader, classLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map map) {
        return JDOHelper.getPersistenceManagerFactory(null, map, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map map, ClassLoader classLoader) {
        return JDOHelper.getPersistenceManagerFactory(null, map, classLoader);
    }

    protected static PersistenceManagerFactory getPersistenceManagerFactory(Map map, Map map2, ClassLoader classLoader) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        if (classLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullLoader"));
        }
        String string = (String)map2.get("javax.jdo.PersistenceManagerFactoryClass");
        if (!JDOHelper.isNullOrBlank(string)) {
            return JDOHelper.invokeGetPersistenceManagerFactoryOnImplementation(string, map, map2, classLoader);
        }
        Enumeration enumeration = null;
        try {
            enumeration = JDOHelper.getResources(classLoader, "META-INF/services/javax.jdo.PersistenceManagerFactory");
        }
        catch (Throwable throwable) {
            arrayList.add(throwable);
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                try {
                    string = JDOHelper.getClassNameFromURL((URL)enumeration.nextElement());
                    PersistenceManagerFactory persistenceManagerFactory = JDOHelper.invokeGetPersistenceManagerFactoryOnImplementation(string, map, map2, classLoader);
                    return persistenceManagerFactory;
                }
                catch (Throwable throwable) {
                    arrayList.add(throwable);
                }
            }
        }
        throw new JDOFatalUserException(msg.msg("EXC_GetPMFNoPMFClassNamePropertyOrPUNameProperty"), arrayList.toArray(new Throwable[arrayList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getClassNameFromURL(URL uRL) throws IOException {
        String string;
        int n2;
        String string2;
        InputStream inputStream = JDOHelper.openStream(uRL);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string3 = null;
        try {
            while ((string3 = bufferedReader.readLine()) != null) {
                if ((string3 = string3.trim()).length() == 0 || string3.startsWith("#")) continue;
                String[] stringArray = string3.split("\\s");
                string2 = stringArray[0];
                n2 = string2.indexOf("#");
                if (n2 != -1) break block10;
                string = string2;
                Object var9_10 = null;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            block10: {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return string;
            }
            String string4 = string2.substring(0, n2);
            Object var9_11 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return string4;
        }
        String string5 = null;
        Object var9_12 = null;
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string5;
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String string) {
        ClassLoader classLoader = JDOHelper.getContextClassLoader();
        return JDOHelper.getPersistenceManagerFactory(null, string, classLoader, classLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String string, ClassLoader classLoader) {
        return JDOHelper.getPersistenceManagerFactory(null, string, classLoader, classLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String string, ClassLoader classLoader, ClassLoader classLoader2) {
        return JDOHelper.getPersistenceManagerFactory(null, string, classLoader, classLoader2);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map map, String string) {
        ClassLoader classLoader = JDOHelper.getContextClassLoader();
        return JDOHelper.getPersistenceManagerFactory(map, string, classLoader, classLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map map, String string, ClassLoader classLoader) {
        return JDOHelper.getPersistenceManagerFactory(map, string, classLoader, classLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map map, String string, ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader2 == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullPMFLoader"));
        }
        if (classLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullPropsLoader"));
        }
        Map map2 = null;
        String string2 = string = string == null ? "" : string.trim();
        if (!"".equals(string)) {
            map2 = JDOHelper.loadPropertiesFromResource(classLoader, string);
        }
        if (map2 != null) {
            map2.put("javax.jdo.option.spi.ResourceName", string);
            map2.remove("javax.jdo.option.Name");
            return JDOHelper.getPersistenceManagerFactory(map, map2, classLoader2);
        }
        map2 = JDOHelper.getPropertiesFromJdoconfig(string, classLoader2);
        if (map2 != null) {
            map2.put("javax.jdo.option.Name", string);
            map2.remove("javax.jdo.option.spi.ResourceName");
            return JDOHelper.getPersistenceManagerFactory(map, map2, classLoader2);
        }
        if (!"".equals(string)) {
            map2 = new Properties();
            map2.put("javax.jdo.option.PersistenceUnitName", string);
            return JDOHelper.getPersistenceManagerFactory(map, map2, classLoader2);
        }
        throw new JDOFatalUserException(msg.msg("EXC_NoPMFConfigurableViaPropertiesOrXML", string));
    }

    protected static PersistenceManagerFactory invokeGetPersistenceManagerFactoryOnImplementation(String string, Map map, Map map2, ClassLoader classLoader) {
        if (map != null) {
            try {
                Class clazz = JDOHelper.forName(string, true, classLoader);
                Method method = JDOHelper.getMethod(clazz, "getPersistenceManagerFactory", new Class[]{Map.class, Map.class});
                PersistenceManagerFactory persistenceManagerFactory = (PersistenceManagerFactory)JDOHelper.invoke(method, null, new Object[]{map, map2});
                if (persistenceManagerFactory == null) {
                    throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNullPMF", string));
                }
                return persistenceManagerFactory;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JDOFatalUserException(msg.msg("EXC_GetPMFClassNotFound", string), classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNoSuchMethod2", string), noSuchMethodException);
            }
            catch (NullPointerException nullPointerException) {
                throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNullPointerException", string), nullPointerException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JDOFatalUserException(msg.msg("EXC_GetPMFIllegalAccess", string), illegalAccessException);
            }
            catch (ClassCastException classCastException) {
                throw new JDOFatalInternalException(msg.msg("EXC_GetPMFClassCastException", string), classCastException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof JDOException) {
                    throw (JDOException)throwable;
                }
                throw new JDOFatalInternalException(msg.msg("EXC_GetPMFUnexpectedException"), invocationTargetException);
            }
        }
        try {
            Class clazz = JDOHelper.forName(string, true, classLoader);
            Method method = JDOHelper.getMethod(clazz, "getPersistenceManagerFactory", new Class[]{Map.class});
            PersistenceManagerFactory persistenceManagerFactory = (PersistenceManagerFactory)JDOHelper.invoke(method, null, new Object[]{map2});
            if (persistenceManagerFactory == null) {
                throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNullPMF", string));
            }
            return persistenceManagerFactory;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFClassNotFound", string), classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNoSuchMethod", string), noSuchMethodException);
        }
        catch (NullPointerException nullPointerException) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNullPointerException", string), nullPointerException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIllegalAccess", string), illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFClassCastException", string), classCastException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof JDOException) {
                throw (JDOException)throwable;
            }
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFUnexpectedException"), invocationTargetException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Map loadPropertiesFromResource(ClassLoader classLoader, String string) {
        InputStream inputStream = null;
        Properties properties = null;
        try {
            try {
                inputStream = JDOHelper.getResourceAsStream(classLoader, string);
                if (inputStream != null) {
                    properties = new Properties();
                    properties.load(inputStream);
                }
            }
            catch (IOException iOException) {
                throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionRsrc", string), iOException);
            }
            Object var6_4 = null;
            if (inputStream == null) return properties;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        return properties;
    }

    protected static Map getPropertiesFromJdoconfig(String string, ClassLoader classLoader) {
        return JDOHelper.getNamedPMFProperties(string, classLoader, "META-INF/jdoconfig.xml");
    }

    protected static Map getNamedPMFProperties(String string, ClassLoader classLoader, String string2) {
        HashMap hashMap = new HashMap();
        try {
            URL uRL = null;
            Enumeration enumeration = JDOHelper.getResources(classLoader, string2);
            if (enumeration.hasMoreElements()) {
                ArrayList<URL> arrayList = new ArrayList<URL>();
                DocumentBuilderFactory documentBuilderFactory = JDOHelper.getDocumentBuilderFactory();
                do {
                    URL uRL2;
                    if (arrayList.contains(uRL2 = (URL)enumeration.nextElement())) continue;
                    arrayList.add(uRL2);
                    Map map = JDOHelper.readNamedPMFProperties(uRL2, string, documentBuilderFactory);
                    if (map.containsKey(string)) {
                        if (uRL == null) {
                            uRL = uRL2;
                        }
                        if (hashMap.containsKey(string)) {
                            throw new JDOFatalUserException(msg.msg("EXC_DuplicateRequestedNamedPMFFoundInDifferentConfigs", "".equals(string) ? "(anonymous)" : string, uRL.toExternalForm(), uRL2.toExternalForm()));
                        }
                    }
                    hashMap.putAll(map);
                } while (enumeration.hasMoreElements());
            }
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new JDOFatalUserException(msg.msg("ERR_NoDocumentBuilderFactory"), factoryConfigurationError);
        }
        catch (IOException iOException) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionRsrc", string), iOException);
        }
        return (Map)hashMap.get(string);
    }

    protected static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = JDOImplHelper.getRegisteredDocumentBuilderFactory();
        if (documentBuilderFactory == null) {
            documentBuilderFactory = JDOHelper.getDefaultDocumentBuilderFactory();
        }
        return documentBuilderFactory;
    }

    protected static DocumentBuilderFactory getDefaultDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setExpandEntityReferences(true);
        return documentBuilderFactory;
    }

    protected static ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = JDOImplHelper.getRegisteredErrorHandler();
        if (errorHandler == null) {
            errorHandler = JDOHelper.getDefaultErrorHandler();
        }
        return errorHandler;
    }

    protected static ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            public void error(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            public void warning(SAXParseException sAXParseException) throws SAXException {
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Map readNamedPMFProperties(URL uRL, String string, DocumentBuilderFactory documentBuilderFactory) {
        HashMap<String, Object> hashMap;
        string = string == null ? "" : string.trim();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        InputStream inputStream = null;
        try {
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setErrorHandler(JDOHelper.getErrorHandler());
                inputStream = JDOHelper.openStream(uRL);
                Document document = documentBuilder.parse(inputStream);
                Element element = document.getDocumentElement();
                if (element == null) {
                    throw new JDOFatalUserException(msg.msg("EXC_InvalidJDOConfigNoRoot", uRL.toExternalForm()));
                }
                NodeList nodeList = element.getElementsByTagName("persistence-manager-factory");
                for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                    Node node = nodeList.item(i2);
                    Properties properties = JDOHelper.readPropertiesFromPMFElementAttributes(node);
                    Properties properties2 = JDOHelper.readPropertiesFromPMFSubelements(node, uRL);
                    String string2 = properties.getProperty("javax.jdo.option.Name");
                    String string3 = properties2.getProperty("javax.jdo.option.Name");
                    String string4 = null;
                    if (JDOHelper.isNullOrBlank(string2)) {
                        string4 = !JDOHelper.isNullOrBlank(string3) ? string3 : "";
                    } else {
                        if (!JDOHelper.isNullOrBlank(string3)) {
                            throw new JDOFatalUserException(msg.msg("EXC_DuplicatePMFNamePropertyFoundWithinConfig", string2, string3, uRL.toExternalForm()));
                        }
                        string4 = string2;
                    }
                    String string5 = string4 = string4 == null ? "" : string4.trim();
                    if (string.equals(string4)) {
                        for (String string6 : properties.keySet()) {
                            if (!properties2.contains(string6)) continue;
                            throw new JDOFatalUserException(msg.msg("EXC_DuplicatePropertyFound", string6, string4, uRL.toExternalForm()));
                        }
                    }
                    Properties properties3 = new Properties();
                    properties3.putAll((Map<?, ?>)properties);
                    properties3.putAll((Map<?, ?>)properties2);
                    if (string4.equals(string) && hashMap2.containsKey(string4)) {
                        throw new JDOFatalUserException(msg.msg("EXC_DuplicateRequestedNamedPMFFoundInSameConfig", string4, uRL.toExternalForm()));
                    }
                    hashMap2.put(string4, properties3);
                }
                hashMap = hashMap2;
                Object var19_25 = null;
                if (inputStream == null) return hashMap;
            }
            catch (IOException iOException) {
                throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionRsrc", uRL.toString()), iOException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new JDOFatalInternalException(msg.msg("EXC_ParserConfigException"), parserConfigurationException);
            }
            catch (SAXParseException sAXParseException) {
                throw new JDOFatalUserException(msg.msg("EXC_SAXParseException", uRL.toExternalForm(), new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber())), sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new JDOFatalUserException(msg.msg("EXC_SAXException", uRL.toExternalForm()), sAXException);
            }
            catch (JDOException jDOException) {
                throw jDOException;
            }
            catch (RuntimeException runtimeException) {
                throw new JDOFatalUserException(msg.msg("EXC_SAXException", uRL.toExternalForm()), runtimeException);
            }
        }
        catch (Throwable throwable) {
            Object var19_26 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return hashMap;
        }
        inputStream.close();
        return hashMap;
    }

    protected static Properties readPropertiesFromPMFElementAttributes(Node node) {
        Properties properties = new Properties();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return properties;
        }
        for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
            Node node2 = namedNodeMap.item(i2);
            String string = node2.getNodeName();
            String string2 = node2.getNodeValue().trim();
            String string3 = (String)ATTRIBUTE_PROPERTY_XREF.get(string);
            properties.put(string3 != null ? string3 : string, string2);
        }
        return properties;
    }

    protected static Properties readPropertiesFromPMFSubelements(Node node, URL uRL) {
        Properties properties = new Properties();
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return properties;
        }
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string;
            Object object;
            String string2;
            Node node2;
            Node node3 = nodeList.item(i2);
            if (node3.getNodeType() != 1) continue;
            String string3 = node3.getNodeName();
            NamedNodeMap namedNodeMap = node3.getAttributes();
            if ("property".equalsIgnoreCase(string3)) {
                node2 = namedNodeMap.getNamedItem("name");
                if (node2 == null) {
                    throw new JDOFatalUserException(msg.msg("EXC_PropertyElementHasNoNameAttribute", uRL));
                }
                string2 = node2.getNodeValue().trim();
                if ("".equals(string2)) {
                    throw new JDOFatalUserException(msg.msg("EXC_PropertyElementNameAttributeHasNoValue", string2, uRL));
                }
                object = (String)ATTRIBUTE_PROPERTY_XREF.get(string2);
                String string4 = string = object != null ? object : string2;
                if (properties.containsKey(string)) {
                    throw new JDOFatalUserException(msg.msg("EXC_DuplicatePropertyNameGivenInPropertyElement", string, uRL));
                }
                Node node4 = namedNodeMap.getNamedItem("value");
                String string5 = node4 == null ? null : node4.getNodeValue().trim();
                properties.put(string, string5);
                continue;
            }
            if (!"instance-lifecycle-listener".equals(string3)) continue;
            node2 = namedNodeMap.getNamedItem("listener");
            if (node2 == null) {
                throw new JDOFatalUserException(msg.msg("EXC_MissingListenerAttribute", uRL));
            }
            string2 = node2.getNodeValue().trim();
            if ("".equals(string2)) {
                throw new JDOFatalUserException(msg.msg("EXC_MissingListenerAttributeValue", uRL));
            }
            string2 = "javax.jdo.listener.InstanceLifecycleListener." + string2;
            object = namedNodeMap.getNamedItem("classes");
            string = object == null ? "" : object.getNodeValue().trim();
            properties.put(string2, string);
        }
        return properties;
    }

    protected static boolean isNullOrBlank(String string) {
        return string == null || "".equals(string.trim());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(File file) {
        return JDOHelper.getPersistenceManagerFactory(file, JDOHelper.getContextClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PersistenceManagerFactory getPersistenceManagerFactory(File file, ClassLoader classLoader) {
        PersistenceManagerFactory persistenceManagerFactory;
        if (file == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullFile"));
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                persistenceManagerFactory = JDOHelper.getPersistenceManagerFactory(fileInputStream, classLoader);
                Object var5_5 = null;
                if (fileInputStream == null) return persistenceManagerFactory;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JDOFatalUserException(msg.msg("EXC_GetPMFNoFile", file), fileNotFoundException);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return persistenceManagerFactory;
        }
        ((InputStream)fileInputStream).close();
        return persistenceManagerFactory;
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String string, Context context) {
        return JDOHelper.getPersistenceManagerFactory(string, context, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String string, Context context, ClassLoader classLoader) {
        if (string == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullJndiLoc"));
        }
        if (classLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullLoader"));
        }
        try {
            if (context == null) {
                context = new InitialContext();
            }
            Object object = context.lookup(string);
            return (PersistenceManagerFactory)PortableRemoteObject.narrow((Object)object, PersistenceManagerFactory.class);
        }
        catch (NamingException namingException) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNamingException", string, classLoader), namingException);
        }
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(InputStream inputStream) {
        return JDOHelper.getPersistenceManagerFactory(inputStream, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(InputStream inputStream, ClassLoader classLoader) {
        if (inputStream == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullStream"));
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionStream"), iOException);
        }
        return JDOHelper.getPersistenceManagerFactory((Map)properties, classLoader);
    }

    static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static InputStream getResourceAsStream(final ClassLoader classLoader, final String string) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return classLoader.getResourceAsStream(string);
            }
        });
    }

    static Method getMethod(final Class clazz, final String string, final Class[] classArray) throws NoSuchMethodException {
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    return clazz.getMethod(string, classArray);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (NoSuchMethodException)privilegedActionException.getException();
        }
    }

    static Object invoke(final Method method, final Object object, final Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, InvocationTargetException {
                    return method.invoke(object, objectArray);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IllegalAccessException) {
                throw (IllegalAccessException)exception;
            }
            throw (InvocationTargetException)exception;
        }
    }

    protected static Enumeration getResources(final ClassLoader classLoader, final String string) throws IOException {
        try {
            return (Enumeration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return classLoader.getResources(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    static Class forName(final String string, final boolean bl, final ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(string, bl, classLoader);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    static InputStream openStream(final URL uRL) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return uRL.openStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }
}

