/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.type;

import com.objectdb.conv.ConvertManager;
import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.common.OldObjectRef;
import com.objectdb.conv1.common.OldTypeCodes;
import com.objectdb.conv1.type.OldArrayTypeInfo;
import com.objectdb.conv1.type.OldObjArrayTypeInfo;
import com.objectdb.conv1.type.OldTypeIds;
import com.objectdb.conv1.type.OldTypeManager;
import com.objectdb.conv1.type.OldUserTypeInfo;
import com.objectdb.o.TYW;

public abstract class OldTypeInfo
extends OldObjectRef
implements Comparable,
OldTypeIds,
OldTypeCodes {
    protected OldTypeManager m_typeManager;
    String m_className;
    protected Class m_class;
    protected int m_typeId;
    protected int m_typeIdAndDim;
    protected OldArrayTypeInfo m_arrayTypeInfo;
    protected int m_primitiveCode;

    protected OldTypeInfo(OldTypeManager oldTypeManager, String string, int n) {
        this(oldTypeManager, n);
        this.m_className = string;
    }

    protected OldTypeInfo(OldTypeManager oldTypeManager, Class clazz, int n) {
        this(oldTypeManager, n);
        this.m_class = clazz;
        this.m_className = clazz.getName();
    }

    protected OldTypeInfo(OldTypeManager oldTypeManager, Class clazz, String string, int n) {
        this(oldTypeManager, n);
        this.m_class = clazz;
        this.m_className = string;
    }

    OldTypeInfo(OldTypeManager oldTypeManager, int n) {
        this.m_typeManager = oldTypeManager;
        if (n != 0) {
            this.setTypeId(n);
        }
    }

    public void setTypeId(int n) {
        this.m_typeId = n;
        this.m_typeIdAndDim = n << 4;
        this.setObjectId(n);
        if (this.m_arrayTypeInfo != null) {
            this.m_arrayTypeInfo.setTypeId(n);
        }
    }

    public final int getTypeId() {
        return this.m_typeId;
    }

    public int getTypeCode() {
        return 13;
    }

    public int getArrayDim() {
        return 0;
    }

    public int getTypeIdAndDim() {
        return this.m_typeIdAndDim;
    }

    public boolean isUpToDate() {
        return true;
    }

    public final OldTypeManager getTypeManager() {
        return this.m_typeManager;
    }

    public final String getClassName() {
        return this.m_className;
    }

    public final void setClassName(String string) {
        this.m_className = string;
    }

    public Class getTypeClass() {
        if (this.m_class == null) {
            this.m_class = this.m_typeManager.findClass(this.m_className);
        }
        return this.m_class;
    }

    public String getPrintableType() {
        return this.m_className;
    }

    public abstract void skipElement(OldBuffer var1);

    static void skipPrimitive(int n, OldBuffer oldBuffer) {
        switch (n) {
            case 1: 
            case 12: {
                oldBuffer.skip(1);
                break;
            }
            case 2: 
            case 3: {
                oldBuffer.skip(2);
                break;
            }
            case 4: {
                oldBuffer.skipCompressedInt();
                break;
            }
            case 5: {
                oldBuffer.skipCompressedLong();
                break;
            }
            case 6: {
                oldBuffer.skip(4);
                break;
            }
            case 7: {
                oldBuffer.skip(8);
                break;
            }
            default: {
                throw new RuntimeException("Internal Exception");
            }
        }
    }

    public final OldArrayTypeInfo getArrayTypeInfo() {
        if (this.m_arrayTypeInfo == null) {
            this.m_arrayTypeInfo = this.createArrayTypeInfo();
            this.m_typeManager.keepTypeInCache(this.m_arrayTypeInfo);
        }
        return this.m_arrayTypeInfo;
    }

    protected OldArrayTypeInfo createArrayTypeInfo() {
        return new OldObjArrayTypeInfo(this.m_typeManager, "[L" + this.m_className + ";", this);
    }

    public final boolean isAssignableFrom(int n) {
        if (n == this.getTypeIdAndDim()) {
            return true;
        }
        OldTypeInfo oldTypeInfo = this.m_typeManager.getTypeInfo(n);
        if (oldTypeInfo != null && !(oldTypeInfo instanceof OldUserTypeInfo)) {
            return false;
        }
        return this.isAssignableFrom(oldTypeInfo);
    }

    public boolean isAssignableFrom(OldTypeInfo oldTypeInfo) {
        if (oldTypeInfo == this) {
            return true;
        }
        Class clazz = this.getTypeClass();
        Class clazz2 = oldTypeInfo.getTypeClass();
        if (clazz == null || clazz2 == null) {
            return false;
        }
        return clazz.isAssignableFrom(clazz2);
    }

    public abstract void convertObject(OldBuffer var1, boolean var2, ConvertManager var3, TYW var4);

    final boolean tryWritingEmpty(ConvertManager convertManager, TYW tYW) {
        return false;
    }
}

