/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.o;

import com.objectdb.o.BGV;
import com.objectdb.o.BLV;
import com.objectdb.o.InternalException;
import com.objectdb.o.NLT;
import com.objectdb.o.SMT;
import com.objectdb.o.VAL;
import com.objectdb.o.VUT;
import com.objectdb.spi.OReader;
import com.objectdb.spi.OWriter;
import java.math.BigInteger;

public final class BGT
extends SMT {
    public BGT() {
        super(-16, BigInteger.class);
        this.g = new NLT(BigInteger.class, this);
    }

    public void writeStrictly(Object object, OWriter oWriter) {
        oWriter.writeBigIntValue((BigInteger)object);
    }

    public Object readAndAdjust(OReader oReader) {
        return this.f(oReader);
    }

    public BigInteger f(OReader oReader) {
        int n2 = oReader.O();
        switch (n2) {
            case 41: {
                return BGV.e;
            }
            case 42: {
                return BGV.ac(oReader.r(1));
            }
            case 43: {
                return BGV.ac(oReader.r(2));
            }
            case 44: {
                return BGV.ac(oReader.r(3));
            }
            case 45: {
                return BGV.ac(oReader.r(4));
            }
            case 46: {
                return BGV.ac(oReader.r());
            }
        }
        if (n2 >= 129 && n2 < 192) {
            return BGT.e(oReader.U(n2 - 128), oReader);
        }
        VAL vAL = VUT.b(n2, oReader);
        if (vAL.G() || vAL == BLV.b) {
            return BigInteger.ZERO;
        }
        if (vAL == BLV.c) {
            return BigInteger.ONE;
        }
        return BGT.d(vAL, oReader);
    }

    static BigInteger e(String string, OReader oReader) {
        try {
            return new BigInteger(string);
        }
        catch (Exception exception) {
            InternalException.c(exception);
            oReader.addFailurePoint();
            return BigInteger.ZERO;
        }
    }

    static BigInteger d(VAL vAL, OReader oReader) {
        try {
            BigInteger bigInteger = vAL.q();
            if (vAL.compareTo(BGV.ad(bigInteger)) != 0) {
                oReader.addFailurePoint();
            }
            return bigInteger;
        }
        catch (Exception exception) {
            oReader.addFailurePoint();
            return BigInteger.ZERO;
        }
    }

    public Object newInstance() {
        return BigInteger.valueOf(0L);
    }

    public boolean checkFirstByte(int n2) {
        return n2 >= 41 && n2 <= 46;
    }
}

