/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.store;

import com.objectdb.conv1.store.OldLinkedPage;
import java.util.ArrayList;

public abstract class OldMultiPage
extends OldLinkedPage {
    OldLinkedPage[] m_contPages;
    int m_pageSize;
    int m_userPageSize;

    protected void init() {
        super.init();
        this.initVariables();
    }

    void initVariables() {
        this.m_pageSize = this.m_dataStore.getPageSize();
        this.m_userPageSize = this.m_pageSize - 12;
    }

    protected void postRead() {
        this.readContPages();
        this.initVariables();
    }

    protected void postCache() {
        this.readContPages();
    }

    void readContPages() {
        ArrayList<OldMultiPage> arrayList = new ArrayList<OldMultiPage>();
        OldLinkedPage oldLinkedPage = this;
        while ((oldLinkedPage = oldLinkedPage.openNextPage(false)) != null) {
            arrayList.add((OldMultiPage)oldLinkedPage);
        }
        this.m_contPages = arrayList.toArray(new OldLinkedPage[arrayList.size()]);
    }

    public void reread() {
        super.reread();
        if (this.m_contPages != null) {
            OldLinkedPage[] oldLinkedPageArray = this.m_contPages;
            int n = oldLinkedPageArray.length;
            while (n-- > 0) {
                oldLinkedPageArray[n].reread();
            }
        }
    }

    public final void forgetContPages() {
        this.m_contPages = null;
    }

    public final byte[] getContent() {
        int n = this.getInt(12);
        byte[] byArray = new byte[n];
        int n2 = this.m_userPageSize;
        int n3 = Math.min(n, n2 - 4);
        System.arraycopy(this.m_data, 16, byArray, 0, n3);
        int n4 = 0;
        int n5 = 0;
        while (n3 < n) {
            n3 = Math.min(n -= n3, n2);
            System.arraycopy(this.m_contPages[n5].getData(), 12, byArray, n4 += n3, n3);
            ++n5;
        }
        return byArray;
    }

    public final int getExtInt(int n) {
        if (n < this.m_pageSize) {
            return this.getInt(n);
        }
        return this.m_contPages[(n -= this.m_pageSize) / this.m_userPageSize].getInt(12 + n % this.m_userPageSize);
    }

    public final long getExtLong(int n) {
        return ((long)this.getExtInt(n) << 32) + ((long)this.getExtInt(n + 4) & 0xFFFFFFFFL);
    }

    public final int getExtByte(int n) {
        byte by;
        if (n < this.m_pageSize) {
            by = this.m_data[n];
        } else {
            OldLinkedPage oldLinkedPage = this.m_contPages[(n -= this.m_pageSize) / this.m_userPageSize];
            by = oldLinkedPage.getData()[12 + n % this.m_userPageSize];
        }
        return by & 0xFF;
    }
}

