/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.store;

import com.objectdb.conv1.store.OldPage;

public final class OldMapperDataPage
extends OldPage {
    static final int POS = 6;
    static final int HASH_MASK_OFFSET = 6;
    static final int HASH_VALUE_OFFSET = 10;
    static final int OBJECT_ID_SIZE_OFFSET = 14;
    static final int PAGE_ID_SIZE_OFFSET = 15;
    static final int HEADER_SIZE1 = 16;
    int m_objectIdSize;
    int m_pageIdSize;
    int m_entrySize;

    protected void init() {
        super.init();
        this.m_reservePos = 16;
        this.setObjectIdSize(2);
        this.setPageIdSize(2);
    }

    void setObjectIdSize(int n) {
        this.m_data[14] = (byte)n;
        this.m_objectIdSize = n;
        this.m_entrySize = this.m_objectIdSize + this.m_pageIdSize;
    }

    void setPageIdSize(int n) {
        this.m_data[15] = (byte)n;
        this.m_pageIdSize = n;
        this.m_entrySize = this.m_objectIdSize + this.m_pageIdSize;
    }

    protected void postRead() {
        super.postRead();
        this.m_objectIdSize = this.m_data[14];
        this.m_pageIdSize = this.m_data[15];
        this.m_entrySize = this.m_objectIdSize + this.m_pageIdSize;
    }

    int getLocation(long l) {
        int n = this.findEntry(l);
        if (n < 0) {
            throw new RuntimeException("Object with ID #" + l + " cannot be found.");
        }
        return this.readPageId(n + this.m_objectIdSize);
    }

    int findEntry(long l) {
        int n = this.m_entrySize;
        int n2 = 0;
        int n3 = (this.m_reservePos - 16) / n - 1;
        while (n2 <= n3) {
            int n4 = n3 + n2 >> 1;
            int n5 = 16 + n4 * n;
            long l2 = this.readObjectId(n5);
            if (l < l2) {
                n3 = n4 - 1;
                continue;
            }
            if (l > l2) {
                n2 = n4 + 1;
                continue;
            }
            return n5;
        }
        return ~(16 + n2 * n);
    }

    long readObjectId(int n) {
        long l = ((this.m_data[n++] & 0xFF) << 8) + (this.m_data[n++] & 0xFF);
        if (this.m_objectIdSize > 2) {
            int n2 = n + this.m_objectIdSize - 2;
            while (n < n2) {
                l = (l << 8) + (long)(this.m_data[n++] & 0xFF);
            }
        }
        return l;
    }

    int readPageId(int n) {
        int n2 = ((this.m_data[n++] & 0xFF) << 8) + (this.m_data[n++] & 0xFF);
        if (this.m_pageIdSize > 2) {
            int n3 = n + this.m_pageIdSize - 2;
            while (n < n3) {
                n2 = (n2 << 8) + (this.m_data[n++] & 0xFF);
            }
        }
        return n2;
    }

    int getHashMask() {
        return this.getInt(6);
    }

    void setHashMask(int n) {
        this.setInt(6, n);
    }

    int getHashValue() {
        return this.getInt(10);
    }

    void setHashValue(int n) {
        this.setInt(10, n);
    }
}

