/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.value;

import com.objectdb.conv1.common.OldBuffer;
import com.objectdb.conv1.common.OldTypeCodes;
import com.objectdb.conv1.type.OldTypeInfo;
import com.objectdb.conv1.type.OldUserTypeInfo;
import com.objectdb.conv1.value.OldBigDecimalValue;
import com.objectdb.conv1.value.OldBigIntegerValue;
import com.objectdb.conv1.value.OldBooleanValue;
import com.objectdb.conv1.value.OldDateValue;
import com.objectdb.conv1.value.OldDoubleValue;
import com.objectdb.conv1.value.OldFloatValue;
import com.objectdb.conv1.value.OldIntValue;
import com.objectdb.conv1.value.OldLongValue;
import com.objectdb.conv1.value.OldObjRefValue;
import com.objectdb.conv1.value.OldObjectValue;
import com.objectdb.conv1.value.OldStringValue;
import java.math.BigDecimal;
import java.math.BigInteger;

public class OldValue
implements Cloneable,
OldTypeCodes {
    public static OldValue constructValue(OldTypeInfo oldTypeInfo) {
        OldValue oldValue = OldValue.constructValue(oldTypeInfo.getTypeCode());
        if (oldTypeInfo instanceof OldUserTypeInfo || Object.class == oldTypeInfo.getTypeClass()) {
            ((OldObjectValue)oldValue).m_mayBePC = true;
        }
        return oldValue;
    }

    public static OldValue constructValue(int n) {
        switch (n) {
            case 1: {
                return new OldIntValue.ByteValue();
            }
            case 2: {
                return new OldIntValue.CharValue();
            }
            case 3: {
                return new OldIntValue.ShortValue();
            }
            case 4: {
                return new OldIntValue();
            }
            case 5: {
                return new OldLongValue();
            }
            case 6: {
                return new OldFloatValue();
            }
            case 7: {
                return new OldDoubleValue();
            }
            case 12: {
                return new OldBooleanValue();
            }
            case 8: {
                return new OldBigIntegerValue();
            }
            case 9: {
                return new OldBigDecimalValue();
            }
            case 10: {
                return new OldStringValue();
            }
            case 11: {
                return new OldDateValue();
            }
            case 13: 
            case 14: {
                return new OldObjectValue();
            }
            case 15: {
                return new OldObjRefValue();
            }
            case 16: {
                return new OldValue();
            }
        }
        throw new RuntimeException("Internal Exception");
    }

    public final OldValue newInstance() {
        try {
            return (OldValue)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal Exception");
        }
    }

    public int getTypeCode() {
        return 16;
    }

    public void set(Object object) {
    }

    public Object get() {
        return null;
    }

    public boolean isNull() {
        return false;
    }

    void assertNotNull() {
        if (this.isNull()) {
            throw new NullPointerException();
        }
    }

    public int intValue() {
        throw new RuntimeException("Internal Exception");
    }

    public long longValue() {
        throw new RuntimeException("Internal Exception");
    }

    public float floatValue() {
        throw new RuntimeException("Internal Exception");
    }

    public double doubleValue() {
        throw new RuntimeException("Internal Exception");
    }

    public BigInteger bigIntegerValue() {
        return new BigInteger(Long.toString(this.longValue()));
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.doubleValue());
    }

    public void writeIndexKey(OldBuffer oldBuffer) {
    }

    public void readIndexKey(OldBuffer oldBuffer) {
    }

    public void skipIndexKey(OldBuffer oldBuffer) {
        oldBuffer.skip(this.getSize());
    }

    public int getSize() {
        return 0;
    }

    public int compare(OldBuffer oldBuffer) {
        return 0;
    }

    public final int search(OldBuffer oldBuffer, int n) {
        int n2;
        while ((n2 = oldBuffer.getPos()) < n) {
            int n3 = this.compare(oldBuffer);
            if (n3 > 0) continue;
            if (n3 == 0) {
                return n2;
            }
            return ~n2;
        }
        return ~n2;
    }

    static void writeGenericNumber(OldBuffer oldBuffer, long l) {
        if (l < 0L) {
            OldValue.writeGenericNumber(oldBuffer, -l, 64);
        } else {
            OldValue.writeGenericNumber(oldBuffer, l, 0);
        }
    }

    static void writeGenericNumber(OldBuffer oldBuffer, long l, int n) {
        int n2 = (int)l & 0x3F;
        if ((long)n2 == l) {
            oldBuffer.writeByte(n + n2);
        } else {
            oldBuffer.writeByte(128 + n + n2);
            oldBuffer.encodeU7(l >>> 6);
        }
    }

    static long readGenericNumber(OldBuffer oldBuffer) {
        byte by = oldBuffer.readByte();
        long l = by & 0x3F;
        if (by < 0) {
            l = oldBuffer.decodeU7(l, 6);
        }
        if ((by & 0x40) != 0) {
            return -l;
        }
        return l;
    }

    static void skipGenericNumber(OldBuffer oldBuffer) {
        while (oldBuffer.readByte() < 0) {
        }
    }

    static int getSizeOfGenericNumber(long l) {
        int n = 1;
        if (l < 0L && (l = -l) < 0L) {
            l = Long.MAX_VALUE;
        }
        if ((l >>= 6) != 0L) {
            do {
                ++n;
            } while ((l >>= 7) != 0L);
        }
        return n;
    }

    public void upgrade(OldValue oldValue, OldBuffer oldBuffer) {
        throw new RuntimeException("Internal Exception");
    }

    public void readFromBuffer(OldBuffer oldBuffer) {
        throw new RuntimeException("Internal Exception");
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

