/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.jpa.criteria;

import com.objectdb.jpa.criteria.AbstractQueryImpl;
import com.objectdb.jpa.criteria.CriteriaElement;
import com.objectdb.jpa.criteria.JpqlWritable;
import com.objectdb.jpa.criteria.JpqlWriter;
import com.objectdb.o.ERR;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Metamodel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CriteriaQueryImpl<T>
extends AbstractQueryImpl<T>
implements CriteriaQuery<T> {
    OrderImpl[] m_order;

    CriteriaQueryImpl(Metamodel metamodel, Class clazz) {
        super(metamodel, clazz);
    }

    public CriteriaQuery<T> select(Selection<? extends T> selection) {
        super.setSelection(selection);
        return this;
    }

    public CriteriaQuery<T> multiselect(Selection<?> ... selectionArray) {
        ERR.assertNotNull(selectionArray);
        Class<Object> clazz = this.getJavaType();
        if (clazz == Object.class && selectionArray.length > 1) {
            clazz = Object[].class;
        }
        boolean bl = clazz != Object.class && clazz != Object[].class && clazz != Tuple.class;
        return this.select((Selection<? extends T>)new CriteriaElement.CompoundSelectionImpl(clazz, bl, selectionArray));
    }

    public CriteriaQuery<T> multiselect(List<Selection<?>> list) {
        ERR.assertNotNull(list);
        return this.multiselect(list.toArray(new Selection[list.size()]));
    }

    @Override
    public CriteriaQuery<T> distinct(boolean bl) {
        super.distinct(bl);
        return this;
    }

    @Override
    public CriteriaQuery<T> where(Expression<Boolean> expression) {
        super.where(expression);
        return this;
    }

    @Override
    public CriteriaQuery<T> where(Predicate ... predicateArray) {
        super.where(predicateArray);
        return this;
    }

    @Override
    public CriteriaQuery<T> groupBy(Expression<?> ... expressionArray) {
        super.groupBy(expressionArray);
        return this;
    }

    @Override
    public CriteriaQuery<T> groupBy(List<Expression<?>> list) {
        super.groupBy(list);
        return this;
    }

    @Override
    public CriteriaQuery<T> having(Expression<Boolean> expression) {
        super.having(expression);
        return this;
    }

    @Override
    public CriteriaQuery<T> having(Predicate ... predicateArray) {
        super.having(predicateArray);
        return this;
    }

    public CriteriaQuery<T> orderBy(List<Order> list) {
        this.m_order = list.toArray(new OrderImpl[list.size()]);
        return this;
    }

    public CriteriaQuery<T> orderBy(Order ... orderArray) {
        return this.orderBy(Arrays.asList(orderArray));
    }

    public List<Order> getOrderList() {
        ArrayList<Order> arrayList = new ArrayList<Order>();
        if (this.m_order != null) {
            arrayList.addAll(Arrays.asList(this.m_order));
        }
        return arrayList;
    }

    public Set<ParameterExpression<?>> getParameters() {
        JpqlWriter jpqlWriter = new JpqlWriter(false, false);
        this.writeJpql(jpqlWriter);
        return jpqlWriter.getParameters();
    }

    @Override
    public void writeJpql(JpqlWriter jpqlWriter) {
        super.writeJpql(jpqlWriter);
        if (this.m_order != null && this.m_order.length > 0) {
            jpqlWriter.write(" ORDER BY ").writeList(this.m_order, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class OrderImpl
    extends JpqlWritable
    implements Order {
        final Expression<?> m_expression;
        final boolean m_isAscending;

        OrderImpl(Expression<?> expression, boolean bl) {
            this.m_expression = expression;
            this.m_isAscending = bl;
        }

        public Expression<?> getExpression() {
            return this.m_expression;
        }

        public boolean isAscending() {
            return this.m_isAscending;
        }

        public Order reverse() {
            return new OrderImpl(this.m_expression, !this.m_isAscending);
        }

        @Override
        void writeJpql(JpqlWriter jpqlWriter) {
            Object object = this.m_expression.getAlias() != null ? this.m_expression.getAlias() : this.m_expression;
            jpqlWriter.write(object, false);
            if (!this.m_isAscending) {
                jpqlWriter.write(" DESC");
            }
        }
    }
}

