/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.jpa.criteria;

import com.objectdb.jpa.criteria.JpqlWritable;
import com.objectdb.o.ALS;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.criteria.ParameterExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JpqlWriter {
    final StringBuilder sb = new StringBuilder(128);
    final boolean m_overrideVarNames;
    Set<ParameterExpression<?>> m_parameterSet = new HashSet(11, 0.75f);
    final ALS m_literalList;
    int m_paramCount;
    int m_rootCount;

    public JpqlWriter(boolean bl, boolean bl2) {
        this.m_overrideVarNames = bl;
        this.m_literalList = bl2 ? new ALS(4) : null;
    }

    public boolean shouldOverrideVarNames() {
        return this.m_overrideVarNames;
    }

    JpqlWriter write(String string) {
        this.sb.append(string);
        return this;
    }

    public JpqlWriter write(Object object, boolean bl) {
        if (object instanceof JpqlWritable) {
            JpqlWritable jpqlWritable = (JpqlWritable)object;
            if (bl && jpqlWritable.needsParenthesis()) {
                this.write("(");
                jpqlWritable.writeJpql(this);
                this.write(")");
            } else {
                jpqlWritable.writeJpql(this);
            }
        } else {
            this.write(String.valueOf(object));
        }
        return this;
    }

    JpqlWriter writeList(Object[] objectArray, boolean bl) {
        if (objectArray.length > 0) {
            this.write(objectArray[0], false);
            for (int i2 = 1; i2 < objectArray.length; ++i2) {
                this.write(",");
                if (bl) {
                    this.write(" ");
                }
                this.write(objectArray[i2], false);
            }
        }
        return this;
    }

    JpqlWriter writeFunction(String string, Object[] objectArray) {
        this.write(string).write("(").writeList(objectArray, false).write(")");
        return this;
    }

    public void writeLiteral(Object object) {
        if (this.m_literalList == null) {
            if (object instanceof String || object instanceof Character) {
                this.write("'");
            }
            this.write(String.valueOf(object));
            if (object instanceof String || object instanceof Character) {
                this.write("'");
            }
        } else {
            this.m_literalList.a(object);
            this.write(":$$cmlp" + this.m_literalList.j());
        }
    }

    int allocateParameterIx() {
        return ++this.m_paramCount;
    }

    void addParameter(ParameterExpression parameterExpression) {
        this.m_parameterSet.add(parameterExpression);
    }

    public Set<ParameterExpression<?>> getParameters() {
        return this.m_parameterSet;
    }

    int allocateRootIx() {
        return ++this.m_rootCount;
    }

    public Object[] getLiterals() {
        return this.m_literalList.u();
    }

    public String toString() {
        return this.sb.toString();
    }
}

