/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.conv1.store;

import com.objectdb.conv1.store.OldBTreePage;
import com.objectdb.conv1.store.OldClassManagerPage;
import com.objectdb.conv1.store.OldDataManagerPage;
import com.objectdb.conv1.store.OldDataMultiPage;
import com.objectdb.conv1.store.OldDataSinglePage;
import com.objectdb.conv1.store.OldExtentPage;
import com.objectdb.conv1.store.OldFirstPage;
import com.objectdb.conv1.store.OldLinkedPage;
import com.objectdb.conv1.store.OldMapperDataPage;
import com.objectdb.conv1.store.OldMapperPage;
import com.objectdb.conv1.store.OldPage;
import com.objectdb.conv1.store.OldPageTypes;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class OldDataStore
implements OldPageTypes {
    static final int PAGE_SIZE = 1024;
    static final int INITIAL_PAGES = 10;
    static final int MIN_PAGE_SIZE = 512;
    static final int MAX_PAGE_SIZE = 65536;
    public static final int INITIAL_VOLUME_SIZE = 10240;
    File m_dbFile;
    RandomAccessFile m_dbRandomFile;
    boolean m_noRecoveryFile = Boolean.getBoolean("com.objectdb.store.no-recovery");
    File m_recoveryFile;
    RandomAccessFile m_recoveryRandomFile;
    OldFirstPage m_firstPage;
    int m_pageSize;
    boolean m_sync = Boolean.getBoolean("com.objectdb.sync");
    public byte[] m_globalPaper;

    public OldDataStore(String string, boolean bl) {
        this.initFiles(string);
        if (!this.m_dbFile.exists()) {
            throw new RuntimeException("Database is not found");
        }
        this.open();
    }

    void initFiles(String string) {
        this.m_dbFile = new File(string);
        if (!this.m_noRecoveryFile) {
            this.initRecoveryFile();
        }
    }

    void initRecoveryFile() {
        String string = System.getProperty("com.objectdb.recovery.path");
        if (string == null) {
            string = this.m_dbFile.getParent();
        }
        this.m_recoveryFile = new File(string, ".$" + this.m_dbFile.getName() + "$");
        try {
            this.m_recoveryRandomFile = new RandomAccessFile(this.m_recoveryFile, "rw");
        }
        catch (IOException iOException) {
            try {
                this.m_recoveryFile.getParentFile().mkdirs();
                this.m_recoveryRandomFile = new RandomAccessFile(this.m_recoveryFile, "rw");
            }
            catch (IOException iOException2) {
                throw new RuntimeException("Failed to create database recovery file", iOException);
            }
        }
    }

    void initVariables() {
        this.m_globalPaper = new byte[this.m_pageSize];
    }

    void open() {
        try {
            File file = new File(this.m_dbFile.getAbsolutePath() + "$tmp");
            if ((!this.m_dbFile.renameTo(file) || !file.renameTo(this.m_dbFile)) && file.mkdirs() && file.delete()) {
                throw new RuntimeException("Database is locked by another user");
            }
            this.m_dbRandomFile = new RandomAccessFile(this.m_dbFile, "rw");
            OldFirstPage.checkSignature(this.m_dbRandomFile);
            this.m_pageSize = this.m_dbRandomFile.readInt();
            this.initVariables();
            if (this.m_pageSize < 512 || this.m_pageSize > 65536) {
                throw new RuntimeException("Bad format for ODB file");
            }
            if (!this.m_noRecoveryFile) {
                this.recoverFromFailure();
            }
            this.m_firstPage = (OldFirstPage)this.openPageWithoutCache(0);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to open database file", iOException);
        }
    }

    public void close() {
        try {
            this.m_dbRandomFile.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public OldFirstPage getFirstPage() {
        return this.m_firstPage;
    }

    public int getPageSize() {
        return this.m_pageSize;
    }

    public float getFileVersion() {
        return this.m_firstPage.getFileVersion();
    }

    public int getPageCount() {
        return this.m_firstPage.getPageCount();
    }

    public OldPage openPage(int n) {
        OldPage oldPage = this.openPageWithoutCache(n);
        return oldPage;
    }

    public OldPage openPageWithoutCache(int n) {
        byte[] byArray = this.readPaper(n);
        byte by = byArray[0];
        OldPage oldPage = this.constructPage(by);
        if (oldPage != null) {
            oldPage.set(this, n, by, byArray);
            oldPage.postRead();
        }
        return oldPage;
    }

    public byte[] readPaper(int n) {
        byte[] byArray = new byte[this.m_pageSize];
        try {
            RandomAccessFile randomAccessFile = this.m_dbRandomFile;
            randomAccessFile.seek((long)n * (long)this.m_pageSize);
            randomAccessFile.readFully(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error reading database page #" + n, iOException);
        }
        return byArray;
    }

    OldPage constructPage(int n) {
        switch (n) {
            case 1: {
                return new OldFirstPage();
            }
            case 2: {
                return new OldClassManagerPage();
            }
            case 3: {
                return new OldMapperPage();
            }
            case 4: {
                return new OldMapperDataPage();
            }
            case 5: {
                return new OldBTreePage();
            }
            case 6: {
                return new OldExtentPage();
            }
            case 7: {
                return new OldDataManagerPage();
            }
            case 8: {
                return new OldDataSinglePage();
            }
            case 9: {
                return new OldDataMultiPage();
            }
            case 10: {
                return new OldLinkedPage();
            }
        }
        return null;
    }

    OldPage getNextPage(int n, boolean[] blArray) {
        while (n < this.m_firstPage.getPageCount()) {
            byte[] byArray;
            byte by;
            if (this.m_firstPage.isAllocatedPageId(n) && blArray[by = (byArray = this.readPaper(n))[0]]) {
                OldPage oldPage = this.constructPage(by);
                oldPage.set(this, n, by, byArray);
                oldPage.postRead();
                return oldPage;
            }
            ++n;
        }
        return null;
    }

    public boolean isAllocatedPageId(int n) {
        return this.m_firstPage.isAllocatedPageId(n);
    }

    void recoverFromFailure() {
        try {
            RandomAccessFile randomAccessFile = this.m_recoveryRandomFile;
            if (randomAccessFile.length() < 4L) {
                return;
            }
            randomAccessFile.seek(0L);
            int n = randomAccessFile.readInt();
            if (n == 0) {
                return;
            }
            byte[] byArray = this.m_globalPaper;
            while (n-- > 0) {
                int n2 = randomAccessFile.readInt();
                randomAccessFile.readFully(byArray);
                this.physWritePage(n2, byArray);
            }
            if (this.m_sync) {
                this.m_dbRandomFile.getFD().sync();
            }
            randomAccessFile.seek(0L);
            randomAccessFile.writeInt(0);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to recover database", exception);
        }
    }

    void physWritePage(int n, byte[] byArray) throws IOException {
        RandomAccessFile randomAccessFile = this.m_dbRandomFile;
        randomAccessFile.seek((long)n * (long)this.m_pageSize);
        randomAccessFile.write(byArray);
    }
}

