/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.io.Closeable;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jdo.FetchPlan;
import javax.jdo.JDOQLTypedSubquery;
import javax.jdo.PersistenceManager;
import javax.jdo.query.BooleanExpression;
import javax.jdo.query.CharacterExpression;
import javax.jdo.query.CollectionExpression;
import javax.jdo.query.DateExpression;
import javax.jdo.query.DateTimeExpression;
import javax.jdo.query.Expression;
import javax.jdo.query.IfThenElseExpression;
import javax.jdo.query.ListExpression;
import javax.jdo.query.MapExpression;
import javax.jdo.query.NumericExpression;
import javax.jdo.query.OrderExpression;
import javax.jdo.query.PersistableExpression;
import javax.jdo.query.StringExpression;
import javax.jdo.query.TimeExpression;

public interface JDOQLTypedQuery<T>
extends Serializable,
Closeable {
    public static final String QUERY_CLASS_PREFIX = "Q";

    public PersistableExpression<T> candidate();

    public <P> Expression<P> parameter(String var1, Class<P> var2);

    public StringExpression stringParameter(String var1);

    public CharacterExpression characterParameter(String var1);

    public NumericExpression<?> numericParameter(String var1);

    default public <N> NumericExpression<N> numericParameter(String string, Class<N> clazz) {
        return this.numericParameter(string);
    }

    public DateExpression dateParameter(String var1);

    public TimeExpression timeParameter(String var1);

    public DateTimeExpression datetimeParameter(String var1);

    public CollectionExpression<?, ?> collectionParameter(String var1);

    default public <E> CollectionExpression<Collection<E>, E> collectionParameter(String string, Class<E> clazz) {
        return this.collectionParameter(string);
    }

    public MapExpression<?, ?, ?> mapParameter(String var1);

    default public <K, V> MapExpression<Map<K, V>, K, V> mapParameter(String string, Class<K> clazz, Class<V> clazz2) {
        return this.mapParameter(string);
    }

    public ListExpression<?, ?> listParameter(String var1);

    default public <E> ListExpression<List<E>, E> listParameter(String string, Class<E> clazz) {
        return this.listParameter(string);
    }

    public <V> Expression<V> variable(String var1, Class<V> var2);

    public JDOQLTypedQuery<T> setCandidates(Collection<T> var1);

    public JDOQLTypedQuery<T> excludeSubclasses();

    public JDOQLTypedQuery<T> includeSubclasses();

    public JDOQLTypedQuery<T> filter(BooleanExpression var1);

    public <V> IfThenElseExpression<V> ifThenElse(Class<V> var1, BooleanExpression var2, Expression<V> var3, Expression<V> var4);

    public <V> IfThenElseExpression<V> ifThenElse(BooleanExpression var1, V var2, Expression<V> var3);

    public <V> IfThenElseExpression<V> ifThenElse(BooleanExpression var1, Expression<V> var2, V var3);

    public <V> IfThenElseExpression<V> ifThenElse(BooleanExpression var1, V var2, V var3);

    public <V> IfThenElseExpression<V> ifThen(Class<V> var1, BooleanExpression var2, Expression<V> var3);

    public <V> IfThenElseExpression<V> ifThen(BooleanExpression var1, V var2);

    public JDOQLTypedQuery<T> groupBy(Expression<?> ... var1);

    public JDOQLTypedQuery<T> having(Expression<?> var1);

    public JDOQLTypedQuery<T> orderBy(OrderExpression<?> ... var1);

    public JDOQLTypedQuery<T> result(boolean var1, Expression<?> ... var2);

    public JDOQLTypedQuery<T> range(NumericExpression<?> var1, NumericExpression<?> var2);

    public JDOQLTypedQuery<T> range(long var1, long var3);

    public JDOQLTypedQuery<T> range(Expression<?> var1, Expression<?> var2);

    public JDOQLTypedSubquery<T> subquery(String var1);

    public <S> JDOQLTypedSubquery<S> subquery(Class<S> var1, String var2);

    public <E> JDOQLTypedSubquery<E> subquery(CollectionExpression<Collection<E>, E> var1, Class<E> var2, String var3);

    public JDOQLTypedQuery<T> setParameters(Map<String, ?> var1);

    public JDOQLTypedQuery<T> setParameter(Expression<?> var1, Object var2);

    public JDOQLTypedQuery<T> setParameter(String var1, Object var2);

    public List<T> executeList();

    public T executeUnique();

    public <R> List<R> executeResultList(Class<R> var1);

    public <R> R executeResultUnique(Class<R> var1);

    public List<Object> executeResultList();

    public Object executeResultUnique();

    public long deletePersistentAll();

    public Integer getDatastoreReadTimeoutMillis();

    public JDOQLTypedQuery<T> datastoreReadTimeoutMillis(Integer var1);

    public Integer getDatastoreWriteTimeoutMillis();

    public JDOQLTypedQuery<T> datastoreWriteTimeoutMillis(Integer var1);

    public Boolean getSerializeRead();

    public JDOQLTypedQuery<T> serializeRead(Boolean var1);

    public boolean isUnmodifiable();

    public JDOQLTypedQuery<T> unmodifiable();

    public boolean getIgnoreCache();

    public JDOQLTypedQuery<T> ignoreCache(boolean var1);

    public JDOQLTypedQuery<T> extension(String var1, Object var2);

    public JDOQLTypedQuery<T> extensions(Map var1);

    public JDOQLTypedQuery<T> saveAsNamedQuery(String var1);

    public PersistenceManager getPersistenceManager();

    public FetchPlan getFetchPlan();

    public void cancelAll();

    public void cancel(Thread var1);

    public void close(Object var1);

    public void closeAll();

    public String toString();
}

