/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.JDOEnhancer;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.spi.I18NHelper;

public class Enhancer {
    static final I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    char NL = (char)10;
    String JAR_FILE_SUFFIX = ".jar";
    String JDO_FILE_SUFFIX = ".jdo";
    String CLASS_FILE_SUFFIX = ".class";
    boolean error = false;
    boolean printAndExit = false;
    List<String> persistenceUnitNames = new ArrayList<String>();
    String directoryName = null;
    ClassLoader loader = null;
    String classPath = null;
    boolean checkOnly = false;
    boolean verbose = false;
    boolean recurse = false;
    StringBuilder errorBuffer = new StringBuilder();
    StringBuilder verboseBuffer = new StringBuilder();
    List<String> fileNames = new ArrayList<String>();
    List<String> classFileNames = new ArrayList<String>();
    List<String> jdoFileNames = new ArrayList<String>();
    List<String> jarFileNames = new ArrayList<String>();
    int numberOfValidatedClasses = 0;
    int numberOfEnhancedClasses = 0;
    Properties properties;

    public static void main(String[] stringArray) {
        Enhancer enhancer = new Enhancer();
        enhancer.run(stringArray);
    }

    void run(String[] stringArray) {
        this.processArgs(stringArray);
        JDOEnhancer jDOEnhancer = null;
        try {
            jDOEnhancer = JDOHelper.getEnhancer();
        }
        catch (JDOException jDOException) {
            jDOException.printStackTrace();
            this.exit(2);
        }
        try {
            int n2;
            int n3;
            this.properties = jDOEnhancer.getProperties();
            this.addVerboseMessage("MSG_EnhancerClass", jDOEnhancer.getClass().getName());
            this.addVerboseMessage("MSG_EnhancerProperty", "VendorName", this.properties.getProperty("VendorName"));
            this.addVerboseMessage("MSG_EnhancerProperty", "VersionNumber", this.properties.getProperty("VersionNumber"));
            Set<Map.Entry<Object, Object>> set = this.properties.entrySet();
            for (Map.Entry<Object, Object> entry : set) {
                if ("VendorName".equals(entry.getKey()) || "VersionNumber".equals(entry.getKey())) continue;
                this.addVerboseMessage("MSG_EnhancerProperty", (String)entry.getKey(), (String)entry.getValue());
            }
            jDOEnhancer.setVerbose(this.verbose);
            if (this.loader != null) {
                jDOEnhancer.setClassLoader(this.loader);
            }
            if ((n3 = this.classFileNames.size()) != 0) {
                jDOEnhancer.addClasses(this.classFileNames.toArray(new String[n3]));
            }
            if ((n2 = this.jdoFileNames.size()) != 0) {
                jDOEnhancer.addFiles(this.jdoFileNames.toArray(new String[n2]));
            }
            if (0 < this.jarFileNames.size()) {
                for (String string : this.jarFileNames) {
                    jDOEnhancer.addJar(string);
                }
            }
            if (this.persistenceUnitNames != null) {
                for (String string : this.persistenceUnitNames) {
                    jDOEnhancer.addPersistenceUnit(string);
                }
            }
            if (this.directoryName != null) {
                jDOEnhancer.setOutputDirectory(this.directoryName);
            }
            if (this.checkOnly) {
                this.numberOfValidatedClasses = jDOEnhancer.validate();
                this.addVerboseMessage("MSG_EnhancerValidatedClasses", this.numberOfValidatedClasses);
            } else {
                this.numberOfEnhancedClasses = jDOEnhancer.enhance();
                this.addVerboseMessage("MSG_EnhancerEnhancedClasses", this.numberOfEnhancedClasses);
            }
            this.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.exit(1);
        }
    }

    void processArgs(String[] stringArray) {
        this.parseArgs(stringArray);
        this.parseFiles(this.fileNames.toArray(new String[this.fileNames.size()]), true, this.recurse);
        this.loader = this.prepareClassLoader(this.classPath);
        if (this.error) {
            this.addErrorMessage(msg.msg("MSG_EnhancerUsage"));
            this.exit(3);
        }
        if (this.printAndExit) {
            this.addVerboseMessage("MSG_EnhancerUsage");
            this.exit(0);
        }
    }

    void parseArgs(String[] stringArray) {
        boolean bl = false;
        this.fileNames = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if ("?".equals(string)) {
                this.printAndExit = true;
                return;
            }
            if (!bl) {
                if (string.startsWith("-")) {
                    String string2 = string.substring(1);
                    if ("help".equals(string2)) {
                        this.addVerboseMessage("MSG_EnhancerProcessing", "-help");
                        this.setPrintAndExit();
                        continue;
                    }
                    if ("h".equals(string2)) {
                        this.addVerboseMessage("MSG_EnhancerProcessing", "-h");
                        this.setPrintAndExit();
                        continue;
                    }
                    if ("v".equals(string2)) {
                        this.addVerboseMessage("MSG_EnhancerProcessing", "-v");
                        this.verbose = true;
                        continue;
                    }
                    if ("verbose".equals(string2)) {
                        this.addVerboseMessage("MSG_EnhancerProcessing", "-verbose");
                        this.verbose = true;
                        continue;
                    }
                    if ("pu".equals(string2)) {
                        if (this.hasNextArgument("MSG_EnhancerProcessing", "-pu", i2, stringArray.length)) {
                            String string3 = stringArray[++i2];
                            this.addVerboseMessage("MSG_EnhancerPersistenceUnitName", string3);
                            this.persistenceUnitNames.add(string3);
                            continue;
                        }
                        this.setError();
                        continue;
                    }
                    if ("cp".equals(string2)) {
                        if (this.hasNextArgument("MSG_EnhancerProcessing", "-cp", i2, stringArray.length)) {
                            this.classPath = stringArray[++i2];
                            this.addVerboseMessage("MSG_EnhancerClassPath", this.classPath);
                            continue;
                        }
                        this.setError();
                        continue;
                    }
                    if ("d".equals(string2)) {
                        if (this.hasNextArgument("MSG_EnhancerProcessing", "-d", i2, stringArray.length)) {
                            this.directoryName = stringArray[++i2];
                            this.addVerboseMessage("MSG_EnhancerOutputDirectory", this.directoryName);
                            continue;
                        }
                        this.setError();
                        continue;
                    }
                    if ("checkonly".equals(string2)) {
                        this.addVerboseMessage("MSG_EnhancerProcessing", "-checkonly");
                        this.checkOnly = true;
                        continue;
                    }
                    if ("r".equals(string2)) {
                        this.addVerboseMessage("MSG_EnhancerProcessing", "-r");
                        this.recurse = true;
                        continue;
                    }
                    this.setError();
                    this.addErrorMessage(msg.msg("ERR_EnhancerUnrecognizedOption", string2));
                    continue;
                }
                bl = true;
                this.fileNames.add(string);
                continue;
            }
            this.fileNames.add(string);
        }
    }

    boolean hasNextArgument(String string, String string2, int n2, int n3) {
        if (n2 + 1 >= n3) {
            this.setError();
            this.addErrorMessage(msg.msg(string, string2));
            this.addErrorMessage(msg.msg("ERR_EnhancerRequiredArgumentMissing"));
            return false;
        }
        return true;
    }

    void parseFiles(String[] stringArray, boolean bl, boolean bl2) {
        for (String string : stringArray) {
            if (string.endsWith(this.JAR_FILE_SUFFIX)) {
                this.jarFileNames.add(string);
                this.addVerboseMessage("MSG_EnhancerJarFileName", string);
                continue;
            }
            if (string.endsWith(this.JDO_FILE_SUFFIX)) {
                this.jdoFileNames.add(string);
                this.addVerboseMessage("MSG_EnhancerJDOFileName", string);
                continue;
            }
            if (string.endsWith(this.CLASS_FILE_SUFFIX)) {
                this.classFileNames.add(string);
                this.addVerboseMessage("MSG_EnhancerClassFileName", string);
                continue;
            }
            File file = new File(string);
            if (!file.isDirectory() || !bl) continue;
            String string2 = file.getAbsolutePath();
            String[] stringArray2 = file.list();
            String[] stringArray3 = new String[1];
            if (stringArray2 == null) continue;
            for (String string3 : stringArray2) {
                stringArray3[0] = string2 + "/" + string3;
                this.parseFiles(stringArray3, bl2, bl2);
            }
        }
    }

    ClassLoader prepareClassLoader(String string) {
        if (string == null) {
            return null;
        }
        URLClassLoader uRLClassLoader = null;
        String string2 = System.getProperty("path.separator");
        String[] stringArray = string.split(string2);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (String string3 : stringArray) {
            File file = new File(string3);
            URI uRI = file.toURI();
            try {
                URL uRL = uRI.toURL();
                this.addVerboseMessage("MSG_EnhancerClassPath", uRL.toString());
                arrayList.add(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                this.setError();
                this.addErrorMessage(msg.msg("ERR_EnhancerBadClassPath", file));
            }
        }
        uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), null);
        return uRLClassLoader;
    }

    void addErrorMessage(String string) {
        this.errorBuffer.append(string);
        this.errorBuffer.append(this.NL);
    }

    void setError() {
        this.error = true;
    }

    void setPrintAndExit() {
        this.printAndExit = true;
    }

    void exit(int n2) {
        System.out.print(this.verboseBuffer.toString());
        System.err.print(this.errorBuffer.toString());
        System.exit(n2);
    }

    void addVerboseMessage(String string, String ... stringArray) {
        this.verboseBuffer.append(msg.msg(string, stringArray));
        this.verboseBuffer.append(this.NL);
    }

    void addVerboseMessage(String string, String string2) {
        this.verboseBuffer.append(msg.msg(string, string2));
        this.verboseBuffer.append(this.NL);
    }

    void addVerboseMessage(String string) {
        this.verboseBuffer.append(msg.msg(string));
        this.verboseBuffer.append(this.NL);
    }

    void addVerboseMessage(String string, int n2) {
        this.addVerboseMessage(string, String.valueOf(n2));
    }
}

