/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.jpa.criteria;

import com.objectdb.jpa.criteria.JoinImpl;
import com.objectdb.jpa.criteria.JpqlWriter;
import com.objectdb.jpa.criteria.PathImpl;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

abstract class FromImpl<Z, T>
extends PathImpl<T>
implements From<Z, T> {
    final From<Z, T> m_correlationParent;
    final List<JoinImpl<T, ?>> m_joinList = new ArrayList(4);
    final List<JoinImpl<T, ?>> m_fetchList = new ArrayList(4);
    String m_varName;
    JpqlWriter m_nameWriter;

    FromImpl(Metamodel metamodel, Path<?> path, Bindable bindable) {
        super(metamodel, path, bindable);
        this.m_correlationParent = null;
    }

    FromImpl(FromImpl<Z, T> fromImpl) {
        super(fromImpl.m_metamodel, fromImpl.getParentPath(), fromImpl.getModel());
        this.m_correlationParent = fromImpl;
    }

    @Override
    public final boolean isCorrelated() {
        return this.m_correlationParent != null;
    }

    @Override
    public final From<Z, T> getCorrelationParent() {
        return this.m_correlationParent;
    }

    @Override
    public final Set<Join<T, ?>> getJoins() {
        return new LinkedHashSet(this.m_joinList);
    }

    @Override
    public final Set<Fetch<T, ?>> getFetches() {
        return new LinkedHashSet(this.m_fetchList);
    }

    @Override
    public final <X, Y> Join<X, Y> join(String string, JoinType joinType) {
        JoinImpl joinImpl = new JoinImpl(this.m_metamodel, this, this.get(string), joinType, false);
        this.m_joinList.add(joinImpl);
        return joinImpl;
    }

    @Override
    public final <X, Y> Join<X, Y> join(String string) {
        return this.join(string, JoinType.INNER);
    }

    @Override
    public final <Y> Join<T, Y> join(SingularAttribute<? super T, Y> singularAttribute, JoinType joinType) {
        return this.join(singularAttribute.getName(), joinType);
    }

    @Override
    public final <Y> Join<T, Y> join(SingularAttribute<? super T, Y> singularAttribute) {
        return this.join(singularAttribute, JoinType.INNER);
    }

    @Override
    public final <Y> CollectionJoin<T, Y> join(CollectionAttribute<? super T, Y> collectionAttribute) {
        return this.join(collectionAttribute, JoinType.INNER);
    }

    @Override
    public final <Y> CollectionJoin<T, Y> join(CollectionAttribute<? super T, Y> collectionAttribute, JoinType joinType) {
        return this.joinCollection(collectionAttribute.getName(), joinType);
    }

    @Override
    public final <X, Y> CollectionJoin<X, Y> joinCollection(String string) {
        return this.joinCollection(string, JoinType.INNER);
    }

    @Override
    public final <X, Y> CollectionJoin<X, Y> joinCollection(String string, JoinType joinType) {
        JoinImpl.CollectionJoinImpl collectionJoinImpl = new JoinImpl.CollectionJoinImpl(this.m_metamodel, this, this.get(string), joinType);
        this.m_joinList.add(collectionJoinImpl);
        return collectionJoinImpl;
    }

    @Override
    public final <Y> SetJoin<T, Y> join(SetAttribute<? super T, Y> setAttribute) {
        return this.join(setAttribute, JoinType.INNER);
    }

    @Override
    public final <Y> SetJoin<T, Y> join(SetAttribute<? super T, Y> setAttribute, JoinType joinType) {
        return this.joinSet(setAttribute.getName(), joinType);
    }

    @Override
    public final <X, Y> SetJoin<X, Y> joinSet(String string) {
        return this.joinSet(string, JoinType.INNER);
    }

    @Override
    public final <X, Y> SetJoin<X, Y> joinSet(String string, JoinType joinType) {
        JoinImpl.SetJoinImpl setJoinImpl = new JoinImpl.SetJoinImpl(this.m_metamodel, this, this.get(string), joinType);
        this.m_joinList.add(setJoinImpl);
        return setJoinImpl;
    }

    @Override
    public final <Y> ListJoin<T, Y> join(ListAttribute<? super T, Y> listAttribute) {
        return this.join(listAttribute, JoinType.INNER);
    }

    @Override
    public final <Y> ListJoin<T, Y> join(ListAttribute<? super T, Y> listAttribute, JoinType joinType) {
        return this.joinList(listAttribute.getName(), joinType);
    }

    @Override
    public final <X, Y> ListJoin<X, Y> joinList(String string) {
        return this.joinList(string, JoinType.INNER);
    }

    @Override
    public final <X, Y> ListJoin<X, Y> joinList(String string, JoinType joinType) {
        JoinImpl.ListJoinImpl listJoinImpl = new JoinImpl.ListJoinImpl(this.m_metamodel, this, this.get(string), joinType);
        this.m_joinList.add(listJoinImpl);
        return listJoinImpl;
    }

    @Override
    public final <K, V> MapJoin<T, K, V> join(MapAttribute<? super T, K, V> mapAttribute) {
        return this.join(mapAttribute, JoinType.INNER);
    }

    @Override
    public final <K, V> MapJoin<T, K, V> join(MapAttribute<? super T, K, V> mapAttribute, JoinType joinType) {
        return this.joinMap(mapAttribute.getName(), joinType);
    }

    @Override
    public final <X, K, V> MapJoin<X, K, V> joinMap(String string) {
        return this.joinMap(string, JoinType.INNER);
    }

    @Override
    public final <X, K, V> MapJoin<X, K, V> joinMap(String string, JoinType joinType) {
        JoinImpl.MapJoinImpl mapJoinImpl = new JoinImpl.MapJoinImpl(this.m_metamodel, this, this.get(string), joinType);
        this.m_joinList.add(mapJoinImpl);
        return mapJoinImpl;
    }

    @Override
    public final <X, Y> Fetch<X, Y> fetch(String string, JoinType joinType) {
        JoinImpl joinImpl = new JoinImpl(this.m_metamodel, this, this.get(string), joinType, true);
        this.m_fetchList.add(joinImpl);
        return joinImpl;
    }

    @Override
    public final <X, Y> Fetch<X, Y> fetch(String string) {
        return this.fetch(string, JoinType.INNER);
    }

    @Override
    public final <Y> Fetch<T, Y> fetch(SingularAttribute<? super T, Y> singularAttribute, JoinType joinType) {
        return this.fetch(singularAttribute.getName(), joinType);
    }

    @Override
    public final <Y> Fetch<T, Y> fetch(SingularAttribute<? super T, Y> singularAttribute) {
        return this.fetch(singularAttribute, JoinType.INNER);
    }

    @Override
    public final <Y> Fetch<T, Y> fetch(PluralAttribute<? super T, ?, Y> pluralAttribute, JoinType joinType) {
        return this.fetch(pluralAttribute.getName(), joinType);
    }

    @Override
    public final <Y> Fetch<T, Y> fetch(PluralAttribute<? super T, ?, Y> pluralAttribute) {
        return this.fetch(pluralAttribute, JoinType.INNER);
    }

    @Override
    void writeJpql(JpqlWriter jpqlWriter) {
        if (this.m_nameWriter != jpqlWriter && (this.m_varName == null || jpqlWriter.shouldOverrideVarNames())) {
            this.m_varName = "$" + jpqlWriter.allocateRootIx();
            this.m_nameWriter = jpqlWriter;
        }
        jpqlWriter.write(this.m_varName);
    }

    void writeJpqlFrom(JpqlWriter jpqlWriter) {
        for (JoinImpl<T, ?> joinImpl : this.m_joinList) {
            joinImpl.writeJpqlJoin(jpqlWriter);
        }
        for (JoinImpl<T, ?> joinImpl : this.m_fetchList) {
            joinImpl.writeJpqlJoin(jpqlWriter);
        }
    }

    @Override
    public <Y> Join<T, Y> join(Class<Y> clazz) {
        return this.join(clazz, JoinType.INNER);
    }

    @Override
    public <Y> Join<T, Y> join(Class<Y> clazz, JoinType joinType) {
        String string = this.resolveAttributeName(clazz);
        return this.join(string, joinType);
    }

    @Override
    public <Y> Join<T, Y> join(EntityType<Y> entityType) {
        return this.join(entityType.getBindableJavaType(), JoinType.INNER);
    }

    @Override
    public <Y> Join<T, Y> join(EntityType<Y> entityType, JoinType joinType) {
        return this.join(entityType.getBindableJavaType(), joinType);
    }

    <Y> String resolveAttributeName(Class<Y> clazz) {
        ManagedType managedType = (ManagedType)((Object)this.getModel());
        String string = null;
        for (Attribute attribute : managedType.getAttributes()) {
            Class<Object> clazz2;
            if (attribute.isCollection()) {
                PluralAttribute pluralAttribute = (PluralAttribute)attribute;
                clazz2 = pluralAttribute.getElementType().getJavaType();
            } else {
                clazz2 = attribute.getJavaType();
            }
            if (!clazz.equals(clazz2)) continue;
            if (string != null) {
                throw new IllegalArgumentException("Ambiguous join: " + managedType.getJavaType().getName() + " has multiple relationships to " + clazz.getName() + ". You must use join(String) instead.");
            }
            string = attribute.getName();
        }
        if (string == null) {
            throw new IllegalArgumentException("No relationship found from " + managedType.getJavaType().getName() + " to " + clazz.getName());
        }
        return string;
    }
}

