/*
 * Decompiled with CFR 0.152.
 */
package com.objectdb.o;

import com.objectdb.o.NLT;
import com.objectdb.o.SMT;
import com.objectdb.o.SYH;
import com.objectdb.o.TYM;
import com.objectdb.o.VUT;
import com.objectdb.spi.OReader;
import com.objectdb.spi.OWriter;
import com.objectdb.spi.TrackableSysType;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;

public final class DAT
extends SMT {
    TrackableSysType h;

    public DAT(int n2, Class clazz, TYM tYM) {
        super(n2, clazz);
        this.f = tYM;
        this.g = new NLT(clazz, this);
    }

    @Override
    public boolean isSysTrackable() {
        switch (this.e) {
            case -40: 
            case -39: 
            case -38: 
            case -37: 
            case -36: 
            case -31: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void writeStrictly(Object object, OWriter oWriter) {
        switch (this.e) {
            case -35: {
                object = ((Calendar)object).getTime();
                break;
            }
            case -36: {
                object = new java.sql.Date(((LocalDate)object).toEpochDay() * 86400000L);
                break;
            }
            case -37: {
                LocalTime localTime = (LocalTime)object;
                Timestamp timestamp = new Timestamp((long)localTime.toSecondOfDay() * 1000L);
                timestamp.setNanos(localTime.getNano());
                object = timestamp;
                break;
            }
            case -38: {
                Instant instant = ((LocalDateTime)object).toInstant(ZoneOffset.UTC);
                Timestamp timestamp = new Timestamp(instant.getEpochSecond() * 1000L);
                timestamp.setNanos(instant.getNano());
                object = timestamp;
                break;
            }
            case -39: {
                OffsetTime offsetTime = (OffsetTime)object;
                Instant instant = offsetTime.atDate(LocalDate.ofEpochDay(0L)).toInstant();
                Timestamp timestamp = new Timestamp(instant.getEpochSecond() * 1000L);
                timestamp.setNanos(instant.getNano());
                object = timestamp;
                break;
            }
            case -40: {
                Instant instant = ((OffsetDateTime)object).toInstant();
                Timestamp timestamp = new Timestamp(instant.getEpochSecond() * 1000L);
                timestamp.setNanos(instant.getNano());
                object = timestamp;
                break;
            }
            case -31: {
                object = Timestamp.from((Instant)object);
            }
        }
        oWriter.writeDate((Date)object);
    }

    @Override
    public final Object readAndAdjust(OReader oReader) {
        int n2 = oReader.O();
        switch (n2) {
            case 73: {
                int n3 = oReader.D();
                long l = 86400000L * (long)n3;
                l = SYH.B(l);
                return this.f(l);
            }
            case 74: {
                int n4 = oReader.G();
                long l = 86400000L * (long)n4;
                l = SYH.B(l);
                return this.f(l);
            }
            case 81: {
                long l = 10 * oReader.S();
                l = SYH.B(l);
                return this.f(l);
            }
            case 75: {
                return this.f(1000L * (long)oReader.G());
            }
            case 77: {
                return this.f(oReader.I());
            }
            case 78: 
            case 80: {
                return this.f(oReader.J());
            }
            case 76: {
                return this.f(1000L * oReader.J());
            }
            case 79: {
                long l = oReader.J();
                int n5 = (int)(l % 10000000L) * 100;
                return this.f(l / 10000000L, n5);
            }
            case 82: {
                long l = oReader.J();
                int n6 = oReader.G();
                return this.f(l, n6);
            }
        }
        VUT.l(n2, oReader);
        oReader.addFailurePoint();
        return this.newInstance();
    }

    Object f(long l) {
        switch (this.e) {
            case -35: {
                return this.e(l);
            }
            case -36: {
                return LocalDate.ofEpochDay(l / 86400000L);
            }
            case -37: {
                return LocalTime.ofNanoOfDay(l % 86400000L * 1000000L);
            }
            case -38: {
                Instant instant = Instant.ofEpochMilli(l);
                return instant.atZone(ZoneOffset.UTC).toLocalDateTime();
            }
            case -39: {
                LocalTime localTime = LocalTime.ofNanoOfDay(l % 86400000L * 1000000L);
                return OffsetTime.of(localTime, ZoneOffset.UTC);
            }
            case -40: {
                Instant instant = Instant.ofEpochMilli(l);
                return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
            }
            case -31: {
                return Instant.ofEpochMilli(l);
            }
        }
        Date date = (Date)((Object)this.d().__odbNewInstance());
        date.setTime(l);
        return date;
    }

    Object f(long l, int n2) {
        long l2 = l * 1000L + (long)(n2 / 1000000);
        switch (this.e) {
            case -35: {
                return this.e(l2);
            }
            case -36: {
                return LocalDate.ofEpochDay(l / 86400L);
            }
            case -37: {
                return LocalTime.ofNanoOfDay(l * 1000000000L + (long)n2);
            }
            case -38: {
                Instant instant = Instant.ofEpochSecond(l, n2);
                return instant.atZone(ZoneOffset.UTC).toLocalDateTime();
            }
            case -39: {
                LocalTime localTime = LocalTime.ofNanoOfDay(l * 1000000000L + (long)n2);
                return OffsetTime.of(localTime, ZoneOffset.UTC);
            }
            case -40: {
                Instant instant = Instant.ofEpochSecond(l, n2);
                return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
            }
            case -31: {
                return Instant.ofEpochSecond(l, n2);
            }
        }
        TrackableSysType trackableSysType = this.d().__odbNewInstance();
        if (trackableSysType instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)((Object)trackableSysType);
            timestamp.setTime(l * 1000L);
            timestamp.setNanos(n2);
            return timestamp;
        }
        Date date = (Date)((Object)trackableSysType);
        date.setTime(l2);
        return date;
    }

    Object e(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(new Date(l));
        return calendar;
    }

    @Override
    public Object newInstance() {
        switch (this.e) {
            case -35: {
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                return calendar;
            }
            case -36: {
                return LocalDate.ofEpochDay(0L);
            }
            case -37: {
                return LocalTime.ofNanoOfDay(0L);
            }
            case -38: {
                Instant instant = Instant.ofEpochMilli(0L);
                return instant.atZone(ZoneOffset.UTC).toLocalDateTime();
            }
            case -39: {
                LocalTime localTime = LocalTime.ofNanoOfDay(0L);
                return OffsetTime.of(localTime, ZoneOffset.UTC);
            }
            case -40: {
                Instant instant = Instant.ofEpochMilli(0L);
                return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
            }
            case -31: {
                return Instant.ofEpochMilli(0L);
            }
        }
        return this.d().__odbNewInstance();
    }

    TrackableSysType d() {
        if (this.h == null && this.e != -35) {
            this.h = this.f.O(this.d);
            this.b = this.h.getClass();
        }
        return this.h;
    }

    @Override
    public boolean checkFirstByte(int n2) {
        return n2 == 0 || n2 >= 73 && n2 <= 82;
    }
}

