/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.spi.JDOPermission;

public class LegacyJava {
    static final boolean isSecurityDeprecated = LegacyJava.initIsSecurityDeprecated();
    static final Method getSecurityManager = isSecurityDeprecated ? null : LegacyJava.findMethod("java.lang.System", "getSecurityManager", new Class[0]);
    static final SecurityManager securityManager = getSecurityManager == null ? null : new SecurityManager();
    public static final Method doPrivilegedAction = LegacyJava.findMethod("java.security.AccessController", "doPrivileged", LegacyJava.class.getName(), PrivilegedAction.class);
    public static final Method doPrivilegedExceptionAction = LegacyJava.findMethod("java.security.AccessController", "doPrivileged", LegacyJava.class.getName(), PrivilegedExceptionAction.class);

    public static SecurityManager getSecurityManager() {
        Object object;
        if (getSecurityManager == null) {
            return null;
        }
        try {
            object = getSecurityManager.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            throw new JDOFatalInternalException(reflectiveOperationException.getMessage());
        }
        if (object == null) {
            return null;
        }
        securityManager.updateSecurityManager(object);
        return securityManager;
    }

    public static boolean isSecurityManagerDeprecated() {
        return isSecurityDeprecated;
    }

    static boolean initIsSecurityDeprecated() {
        try {
            Method method = System.class.getMethod("getSecurityManager", new Class[0]);
            return method.isAnnotationPresent(Deprecated.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return true;
        }
    }

    static Method findMethod(String string, String string2, Class<?> ... classArray) {
        if (isSecurityDeprecated) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.getMethod(string2, classArray);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            throw new JDOFatalInternalException(reflectiveOperationException.getMessage());
        }
    }

    static Method findMethod(String string, String string2, String string3, Class<?> ... classArray) {
        if (isSecurityDeprecated) {
            string = string3;
        }
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.getMethod(string2, classArray);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            throw new JDOFatalInternalException(reflectiveOperationException.getMessage());
        }
    }

    public static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        return privilegedAction.run();
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> privilegedExceptionAction) throws PrivilegedActionException {
        try {
            return privilegedExceptionAction.run();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
    }

    public static class SecurityManager {
        Object sm = null;
        Method checkPermissionMethod = null;

        public void checkPermission(JDOPermission jDOPermission) {
            try {
                this.checkPermissionMethod.invoke(null, jDOPermission);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
                throw new JDOFatalInternalException(reflectiveOperationException.getMessage());
            }
        }

        public void updateSecurityManager(Object object) {
            if (this.sm != object) {
                this.sm = object;
                this.checkPermissionMethod = object != null ? LegacyJava.findMethod("java.lang.SecurityManager", "checkPermission", Permission.class) : null;
            }
        }
    }
}

