package de.vfst.odb;

import java.io.File;
import java.util.Arrays;

import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;

public class F681
{

	public static void main(String[] args)
	{
		File dbdir = new File(System.getProperty("user.dir"));
		ODBSetup dbCreator = new ODBSetup();
		EntityManagerFactory emf = dbCreator.setUpDB("QueryWithEnumTest", dbdir);
		EntityManager em = emf.createEntityManager();

		em.getTransaction().begin();
		em.persist(new MyEntity(MyEnumType.VALUE1));
		em.persist(new MyEntity(MyEnumType.VALUE2));
		em.getTransaction().commit();

		Query query = em.createQuery("SELECT o FROM MyEntity o WHERE (enumField IN :enumFieldList)");
		query.setParameter("enumFieldList", Arrays.asList(MyEnumType.VALUE1, MyEnumType.VALUE3));
		System.out.println(query.getResultList());

		em.close();
		emf.close();
	}

	@Entity
	public static class MyEntity
	{
		MyEntity(MyEnumType enumField)
		{
			this.enumField = enumField;
		}

		MyEnumType enumField;

		@Override
		public String toString()
		{
			return String.valueOf(enumField);
		}
	}

	public enum MyEnumType {
		VALUE1, VALUE2, VALUE3, VALUE4
	}
}