package de.vfst.odb.entities;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

@Entity
@Table(name = "NTT")
@NamedQueries({@NamedQuery(name = Ntt.LIST_BY_CATEGORY, query = "select n from Ntt n where n.category = :cat"),
		@NamedQuery(name = Ntt.LIST_BY_CATEGORY_LIST, query = "select n from Ntt n where n.category in (:catlist)"),
		@NamedQuery(name = Ntt.LIST_BY_ID, query = "select n from Ntt n where n.id in (:idlist)") })
public class Ntt
{
	public static final String LIST_BY_CATEGORY = "de.vfst.odb.entities.Ntt.BY_CAT";

	public static final String LIST_BY_CATEGORY_LIST = "de.vfst.odb.entities.Ntt.BY_CATLIST";

	public static final String LIST_BY_ID = "de.vfst.odb.entities.Ntt.BY_ID";

	@Id
	@Column(name = "id", nullable = false)
	private String id;

	@Column(name = "category", nullable = false)
	@Enumerated(EnumType.STRING)
	private Category category;

	// default constructor
	public Ntt()
	{
	}

	// convenience constructor
	public Ntt(String id, Category cat)
	{
		this.id = id;
		category = cat;
	}

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public Category getCategory()
	{
		return category;
	}

	public void setCategory(Category category)
	{
		this.category = category;
	}

}
