/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.example.demo;

import com.example.demo.db.Db;
import com.example.demo.model.Customer;
import java.util.List;

/**
 *
 * @author dvuksano
 */
public class SaveTask implements Runnable  {

    final List<Customer> c;
    
    public SaveTask(List<Customer> customers) {
        c = customers;
    }
    
    static final Object commitLock = new Object();
    
    @Override
    public void run() {
        synchronized(commitLock) {
            try(Db db = new Db(true)) {
                System.out.println("Start: " + db.getDbIndex());
                db.getEM().getTransaction().begin();
                for (Customer c1 : c)
                    db.getEM().persist(c1);
                    db.getEM().getTransaction().commit();
                System.out.println("End: " + db.getDbIndex());
            }
        }
    }
    
}
