/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.example.demo.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.jdo.annotations.Index;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 *
 * @author dvuksano
 */
@Entity
@Table(name="city")
public class City {

    @Id
    private int zip;
    //@Index(name="ix_city_zip")

    @Index(name="ix_city_state")
    private String state;

    public City() { }
    
    public City(int zip, String state) {
        this.zip = zip;
        this.state = state;
    }
    
    public int getZip() {
        return zip;
    }

    public String getState() {
        return state;
    }

    private static final Map<String, City> cities = new HashMap();
    
    public static City getCity() {
        if (cities.isEmpty()) {
            cities.put("0", new City(92021, "EC"));
            cities.put("1", new City(92019, "SD"));
            cities.put("2", new City(93333, "OJ"));
            cities.put("3", new City(94444, "SF"));
            cities.put("4", new City(91303, "WH"));
            cities.put("5", new City(10019, "NY"));
            cities.put("6", new City(8019, "NJ"));
            cities.put("7", new City(34652, "TP"));
        }
        
        Random r = new Random();
        City c = cities.get( String.valueOf(r.nextInt(8)) );
        
        return c;
    }
}
