/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.example.demo.model;

import java.util.Random;
import javax.jdo.annotations.Index;
import javax.persistence.CascadeType;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
//import javax.jdo.annotations.Index;
import javax.persistence.Table;

/**
 *
 * @author dvuksano
 */
@Entity
@Table(name="customer")
public class Customer {
    @Id
    @GeneratedValue
    private long customerId;
    
    private String firstName;
    private String lastName;
    
    @Index(name="ix_cust_price")
    private int price;

    @Index(name="ix_cust_age")
    private byte age;

    @Index(name="ix_cust_type")
    private String type;

    @Index(name="ix_cust_rank")
    private int rank;


    @ManyToOne(targetEntity = City.class, cascade = CascadeType.ALL, fetch = FetchType.LAZY)
    City cityFrom;

    @ManyToOne(targetEntity = City.class, cascade = CascadeType.ALL, fetch = FetchType.LAZY)
    City cityTo;

    
    
    public long getId() {
        return customerId;
    }

    public String getFirstName() {
        return firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public double getPrice() {
        return 1. * price / 100;
    }
    
    public byte getAge() {
        return age;
    }

    public String getType() {
        return type;
    }

    public int getRank() {
        return rank;
    }

    public City getCityFrom() {
        return cityFrom;
    }

    public City getCityTo() {
        return cityTo;
    }

    static final String[] TYPES = {"AA", "A0", "A1", "A2", "A3", "A4"};
    
    protected Customer() {}

    public Customer(String firstName, String lastName) {
        this.firstName = firstName;
        this.lastName = lastName;
        
        Random r = new Random();
        price = (r.nextInt(1320 * 100) + 1);
        int a = r.nextInt(79) + 1;
        age = Byte.valueOf( Integer.toString(a) );
        
        type = TYPES[r.nextInt(TYPES.length)];
        
        rank = (price <= 0) ? 0 : 1000000 * age / price;
        
        cityTo = City.getCity();
        cityFrom = City.getCity();
    }

    @Override
    public String toString() {
        return String.format(
                "Customer[id=%s, firstName='%s', lastName='%s', price=%.2f, age=%d]",
                customerId, firstName, lastName, getPrice());
    }

}
