/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.example.demo.rest;

import com.example.demo.db.Db;
import com.example.demo.model.Customer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 *
 * @author dvuksano
 */
@RestController
public class FilterRest {
    @RequestMapping("/price")
    public List<Customer> getByPrice() {
        return getByPriceId(Db.getLastId());
    }

    @RequestMapping("/{id}/price")
    public List<Customer> getByPriceId(@PathVariable("id") int id) {
        
        List<Customer> query;
        try(Db db = new Db(id)) {
            long records = 
                (long)db.getEM().createQuery("SELECT COUNT(p) FROM Customer p").getSingleResult();
            System.out.println("RECORDS: " + records);
            
            query =
                db.getEM().createQuery("SELECT p FROM Customer p ORDER BY price", Customer.class)
                    .setMaxResults(10)
                    //.setHint("objectdb.result-fetch", "LAZY")
                    .getResultList();
        }
       
        return query;
    }

    
    @RequestMapping("/age")
    public List<Customer> getByAge() {
        return getByAgeId(Db.getLastId());
    }

    @RequestMapping("/{id}/age")
    List<Customer> getByAgeId(@PathVariable("id") int id) {
        
        List<Customer> query;
        try(Db db = new Db(id)) {

        query =
            db.getEM().createQuery("SELECT p FROM Customer p ORDER BY age", Customer.class)
                .setMaxResults(10)
                //.setHint("objectdb.result-fetch", "LAZY")
                .getResultList();
        }
       
        return query;
    }
    
    @RequestMapping("/{id}/age/avg")
    public List <Object[] > getByAgeAvgId(@PathVariable("id") int id) {
        
        List< Object[] > result;

        try(Db db = new Db(id)) {

        result =
            db.getEM().createQuery("SELECT p.age, COUNT(p.customerId) AS num FROM Customer p GROUP BY p.age ORDER BY p.age", Object[].class)
                .setMaxResults(10)
                //.setHint("objectdb.result-fetch", "LAZY")
                .getResultList();
        }
       
        return result;
    }
    
    @RequestMapping("/{id}/age/avg/{zip}")
    public List <Object[] > getByAgeAvgIdZip(@PathVariable("id") int id, @PathVariable("zip") int zip) {
        
        List< Object[] > result;

        try(Db db = new Db(id)) {

        result =
            db.getEM().createQuery("SELECT p.age, COUNT(p.customerId) AS num FROM Customer p JOIN p.cityFrom c WHERE c.zip = :zip GROUP BY p.age ORDER BY p.age", Object[].class)
                .setParameter("zip", zip)
                .setMaxResults(10)
                //.setHint("objectdb.result-fetch", "LAZY")
                .getResultList();
        }
       
        return result;
    }



    @RequestMapping("/rank")
    List<Customer> getByRankId() {
        return getByRankId(Db.getLastId());
    }
    @RequestMapping("/{id}/rank")
    List<Customer> getByRankId(@PathVariable("id") int id) {
        
        List<Customer> query;
        try(Db db = new Db()) {

        query =
            db.getEM().createQuery("SELECT p FROM Customer p ORDER BY p.rank desc", Customer.class)
                .setMaxResults(10)
                //.setHint("objectdb.result-fetch", "LAZY")
                .getResultList();
        }
       
        return query;
    }

    
    @RequestMapping("/type")
    List<Customer> getByTypes() {
        return getByTypesId(Db.getLastId());
    }
    @RequestMapping("/{id}/type")
    List<Customer> getByTypesId(@PathVariable("id") int id) {
        
        List<Customer> query;
        try(Db db = new Db()) {

            query =
                db.getEM().createQuery("SELECT p FROM Customer p ORDER BY p.type", Customer.class)
                    .setMaxResults(10)
                    //.setHint("objectdb.result-fetch", "LAZY")
                    .getResultList();
        }
       
        return query;
    }

    @RequestMapping("/from")
    List<Customer> getByFrom() {
        return getByFromId(Db.getLastId());
    }
    @RequestMapping("/{id}/from")
    List<Customer> getByFromId(@RequestParam(name = "zip", required = false, defaultValue = "0") int zip) {
        if (zip == 0)
            zip = 92021;
        List<Customer> query;
        try(Db db = new Db()) {

            query =
                db.getEM().createQuery("SELECT p FROM Customer p JOIN p.cityFrom c WHERE c.zip = :zip ORDER BY p.rank", Customer.class)
                    .setParameter("zip", zip)
                    .setMaxResults(10)
                    //.setHint("objectdb.result-fetch", "LAZY")
                    .getResultList();
        }
       
        return query;
    }

    
    
    
    @RequestMapping("/export")
    List<Customer> getCustomers() {
        ArrayList<Customer> c = new ArrayList<>();
        for (int i = 0; i < 10000; i++) {
            c.add(new Customer("Jack", "Bauer"));
            c.add(new Customer("Chloe", "O'Brian"));
            c.add(new Customer("Kim", "Bauer"));
            c.add(new Customer("David", "Palmer"));
            c.add(new Customer("Michelle", "Dessler"));
            c.add(new Customer("John", "Doe"));
            c.add(new Customer("Jack", "Doe"));
        }
        return c;
    }

}
